/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractGeneratedDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusElementTypes;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusParserProvider;
import org.eclipse.sirius.diagram.ui.tools.api.figure.SiriusWrapLabel;

public class DNodeListNameEditPart
extends AbstractGeneratedDiagramNameEditPart
implements ITextAwareEditPart {
    public static final int VISUAL_ID = 5007;

    public DNodeListNameEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicy(){

            protected List createSelectionHandles() {
                ArrayList handles = new ArrayList();
                NonResizableHandleKit.addMoveHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), handles);
                return handles;
            }

            public Command getCommand(Request request) {
                return null;
            }

            public boolean understandsRequest(Request request) {
                return false;
            }
        });
        this.removeEditPolicy("Snap Feedback");
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new NodeCreationEditPolicy(){

            public EditPart getTargetEditPart(Request request) {
                return this.getHost().getParent();
            }
        });
    }

    public void setLabel(SiriusWrapLabel figure) {
        this.unregisterVisuals();
        this.setFigure((IFigure)figure);
        this.defaultText = this.getLabelTextHelper((IFigure)figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    public IParser getParser() {
        if (this.parser == null) {
            String parserHint = ((View)this.getModel()).getType();
            SiriusParserProvider.HintAdapter hintAdapter = new SiriusParserProvider.HintAdapter(SiriusElementTypes.DNodeList_2003, this.getParserElement(), parserHint);
            this.parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
        }
        return this.parser;
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (DiagramPackage.eINSTANCE.getDDiagramElementContainer_OwnedStyle() == feature) {
            this.refreshVisuals();
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createFigure() {
        return null;
    }

    @Override
    public void setLabel(IFigure figure) {
        if (figure instanceof SiriusWrapLabel) {
            this.setLabel((SiriusWrapLabel)figure);
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
        }
    }

    public List getSemanticElements() {
        View view = (View)this.getModel();
        EObject viewpointElement = view.getElement();
        if (viewpointElement instanceof DDiagramElement) {
            List semanticElements = Collections.unmodifiableList(((DDiagramElement)viewpointElement).getSemanticElements());
            return semanticElements;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isSelectable() {
        return super.isSelectable() && this.getParent().isSelectable();
    }
}

