/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.layout;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.swt.widgets.Display;

public class SiriusCanonicalLayoutCommand
extends RecordingCommand
implements AbstractCommand.NonDirtying {
    private static final String ARRANGE_CREATED_VIEWS_CMD_LABEL = "Arrange Created views";
    private IGraphicalEditPart diagramEditPart;
    private List<IAdaptable> childViewsAdapters;
    private List<IAdaptable> childViewsAdaptersForCenterLayout;

    public SiriusCanonicalLayoutCommand(TransactionalEditingDomain domain, DiagramEditPart diagramEditPart) {
        this(domain, (IGraphicalEditPart)diagramEditPart, null, null);
    }

    public SiriusCanonicalLayoutCommand(TransactionalEditingDomain domain, IGraphicalEditPart parentEditPart, List<IAdaptable> childViewsAdapters, List<IAdaptable> childViewsAdaptersForCenterLayout) {
        super(domain, ARRANGE_CREATED_VIEWS_CMD_LABEL);
        this.diagramEditPart = parentEditPart;
        this.childViewsAdapters = childViewsAdapters;
        this.childViewsAdaptersForCenterLayout = childViewsAdaptersForCenterLayout;
    }

    protected void doExecute() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SiriusCanonicalLayoutCommand.this.childViewsAdapters == null && SiriusCanonicalLayoutCommand.this.childViewsAdaptersForCenterLayout == null) {
                    SiriusCanonicalLayoutCommand.this.executeLayoutOnDiagramOpening();
                } else {
                    SiriusCanonicalLayoutCommand.this.executeLayoutDueToExternalChanges();
                }
            }
        });
    }

    private void executeLayoutOnDiagramOpening() {
        Command arrangeCmd = SiriusLayoutDataManager.INSTANCE.getArrangeCreatedViewsOnOpeningCommand(this.diagramEditPart);
        if (arrangeCmd != null && arrangeCmd.canExecute()) {
            arrangeCmd.execute();
        }
    }

    private void executeLayoutDueToExternalChanges() {
        Command arrangeCmd = SiriusLayoutDataManager.INSTANCE.getArrangeCreatedViewsCommand(this.childViewsAdapters, this.childViewsAdaptersForCenterLayout, this.diagramEditPart);
        if (arrangeCmd != null && arrangeCmd.canExecute()) {
            arrangeCmd.execute();
        }
    }
}

