/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.decorators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListElementEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeNameEditPart;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractSiriusDecorator
extends AbstractDecorator {
    protected static final int MARGIN = -1;
    private List<IDecoration> decorations = Collections.emptyList();

    public AbstractSiriusDecorator(IDecoratorTarget decoratorTarget) {
        super(decoratorTarget);
    }

    public void activate() {
    }

    public void refresh() {
        this.removeDecorations();
        View view = (View)this.getDecoratorTarget().getAdapter(View.class);
        if (view != null && (this.shouldConsiderDetachedViews() || view.eResource() != null)) {
            Image decorationImage;
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (!this.shouldBeDecorated(editPart)) {
                return;
            }
            int margin = -1;
            if (editPart instanceof GraphicalEditPart) {
                margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
            }
            if ((decorationImage = this.getDecorationImage(editPart)) != null) {
                if (editPart instanceof AbstractConnectionEditPart) {
                    this.addDecoration(this.getDecoratorTarget().addConnectionDecoration(decorationImage, 50, false));
                } else {
                    this.addDecoration(this.getDecoratorTarget().addShapeDecoration(decorationImage, this.getDirection(editPart), margin, false));
                }
            }
        }
    }

    protected boolean shouldConsiderDetachedViews() {
        return false;
    }

    protected void refresh(EditPart editPart) {
    }

    protected abstract IDecoratorTarget.Direction getDirection(EditPart var1);

    protected boolean shouldBeDecorated(EditPart editPart) {
        boolean shouldBeDecorated = true;
        if (editPart == null || editPart.getParent() == null || editPart.getRoot() == null || editPart.getViewer() == null) {
            shouldBeDecorated = false;
        } else if (editPart instanceof AbstractDiagramNameEditPart && !(editPart instanceof DNodeListElementEditPart)) {
            shouldBeDecorated = false;
        } else if (editPart instanceof GraphicalEditPart) {
            shouldBeDecorated = this.figureIsBigEnoughToBeDecorated(editPart);
        }
        return shouldBeDecorated;
    }

    private boolean figureIsBigEnoughToBeDecorated(EditPart editPart) {
        IFigure figure = ((GraphicalEditPart)editPart).getFigure();
        Dimension size = figure.getSize();
        return size.width >= 10 || size.width <= 0 || size.height >= 10 || size.height <= 0;
    }

    protected abstract Image getDecorationImage(EditPart var1);

    private void removeDecorations() {
        for (IDecoration decoration : this.decorations) {
            GraphicalEditPart ownerEditPart;
            if (decoration instanceof IFigure && ((IFigure)decoration).getParent() != null) {
                ((IFigure)decoration).getParent().remove((IFigure)decoration);
            }
            if ((ownerEditPart = (GraphicalEditPart)this.getDecoratorTarget().getAdapter(GraphicalEditPart.class)) == null || ownerEditPart.getRoot() == null || ownerEditPart.getViewer() == null) continue;
            ownerEditPart.getViewer().getVisualPartMap().remove(decoration);
        }
        this.decorations = new ArrayList<IDecoration>();
    }

    public void deactivate() {
        this.removeDecorations();
    }

    public List<IDecoration> getDecorations() {
        return this.decorations;
    }

    public void addDecoration(IDecoration decoration) {
        this.decorations.add(decoration);
    }

    protected EObject getUnderlyingSemanticElement(EditPart editPart) {
        EObject result = null;
        if (editPart == null) {
            return result;
        }
        if (editPart instanceof IDiagramElementEditPart) {
            result = ((IDiagramElementEditPart)editPart).resolveTargetSemanticElement();
        }
        return result;
    }

    public boolean isDecorableEditPart(IDiagramElementEditPart editPart) {
        EditPart parentEditPart;
        boolean result = true;
        if (editPart instanceof DNodeNameEditPart) {
            EditPart parentEditPart2 = editPart.getParent();
            if (!(parentEditPart2 instanceof DNodeListEditPart) && !(parentEditPart2 instanceof AbstractDiagramListEditPart)) {
                result = false;
            }
        } else if (editPart instanceof DNodeListNameEditPart) {
            result = false;
        } else if (editPart instanceof DNodeListElementEditPart && (parentEditPart = editPart.getParent()).getModel() instanceof View && editPart.getNotationView() != null) {
            View parentView = (View)parentEditPart.getModel();
            result = parentView.getElement() != null && !parentView.getElement().equals(editPart.getNotationView().getElement());
        }
        return result;
    }
}

