/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.refresh;

import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.refresh.RefreshRunnableWithProgress;
import org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.part.DDiagramHelper;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.RetargetAction;

public class RefreshDiagramAction
extends RetargetAction {
    private ISelection selection;

    public RefreshDiagramAction(String actionID, ImageDescriptor imageDescriptor) {
        super(actionID, "Refresh diagram", 1);
        this.setImageDescriptor(imageDescriptor);
    }

    public void run() {
        this.selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        RefreshDiagramAction.refresh(this.selection);
    }

    public static void refresh(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            DDiagram diagram;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Collection<EditPart> minimizedSelection = RefreshDiagramAction.minimizeSelection(Arrays.asList(structuredSelection.toArray()));
            if (!minimizedSelection.isEmpty() && (diagram = DDiagramHelper.findParentDDiagram((IGraphicalEditPart)Iterables.filter(minimizedSelection, IGraphicalEditPart.class).iterator().next())) != null) {
                RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed((DRepresentation)diagram);
            }
            Shell activeShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
            try {
                monitorDialog.run(true, false, (IRunnableWithProgress)new RefreshRunnableWithProgress(minimizedSelection));
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)activeShell, (String)"Error", (String)e.getTargetException().getMessage());
                SiriusPlugin.getDefault().error("Error while refreshing diagram", (Throwable)e);
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)activeShell, (String)"Cancelled", (String)e.getMessage());
            }
        }
    }

    public void runWithEvent(Event event) {
        super.runWithEvent(event);
        this.run();
    }

    private static Collection<EditPart> minimizeSelection(List<?> selection) {
        ArrayList<EditPart> result = new ArrayList<EditPart>(selection.size());
        Iterator<?> iterSelection = new ArrayList(selection).iterator();
        while (iterSelection.hasNext()) {
            Object next = iterSelection.next();
            if (next instanceof EditPart) {
                EditPart editPart = (EditPart)next;
                if (RefreshDiagramAction.isNotAChild(editPart, selection)) {
                    result.add(editPart);
                    continue;
                }
                iterSelection.remove();
                continue;
            }
            iterSelection.remove();
        }
        return result;
    }

    private static boolean isNotAChild(EditPart editPart, Collection<?> selection) {
        boolean result = true;
        Iterator<?> iterEditParts = selection.iterator();
        while (iterEditParts.hasNext() && result) {
            EditPart currentEditPart = (EditPart)iterEditParts.next();
            if (currentEditPart == editPart || !iterEditParts.hasNext()) continue;
            boolean bl = result = !RefreshDiagramAction.isAChild(editPart, (EditPart)iterEditParts.next());
        }
        return result;
    }

    private static boolean isAChild(EditPart mayBeChild, EditPart editPart) {
        boolean res = false;
        if (editPart.getChildren().contains(mayBeChild)) {
            res = true;
        }
        Iterator iterChildren = editPart.getChildren().iterator();
        while (iterChildren.hasNext() && !res) {
            EditPart currentEditPart = (EditPart)iterChildren.next();
            res = RefreshDiagramAction.isAChild(mayBeChild, currentEditPart);
        }
        return res;
    }

    public boolean isEnabled() {
        return true;
    }

    public void dispose() {
        super.dispose();
        this.selection = null;
    }
}

