/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands.emf;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.ui.tools.internal.clipboard.SiriusClipboardManager;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class PasteFromSiriusClipboardCommand
extends RecordingCommand {
    private final EObject container;
    private TransactionalEditingDomain domain;
    private Command paste;
    private Collection<Object> clipboard;

    public PasteFromSiriusClipboardCommand(TransactionalEditingDomain domain, EObject semanticContainer) {
        super(domain, "Generic Paste from clipboard");
        this.domain = domain;
        this.container = semanticContainer;
    }

    protected boolean prepare() {
        this.prepareClipboard();
        this.paste = PasteFromClipboardCommand.create((EditingDomain)this.domain, (Object)this.container, null);
        return this.paste.canExecute();
    }

    private void prepareClipboard() {
        SiriusClipboardManager.getInstance().setDomainClipboard(this.domain);
        this.clipboard = this.domain.getClipboard();
        if (this.clipboard != null) {
            this.clipboard = Lists.newArrayList((Iterable)Iterables.filter(this.clipboard, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(DSemanticDecorator.class))));
        }
        this.domain.setClipboard(this.clipboard);
    }

    protected void doExecute() {
        this.domain.setClipboard(this.clipboard);
        this.paste.execute();
    }
}

