/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import org.eclipse.core.runtime.IConfigurationElement;

public abstract class AbstractProviderDescriptor
implements Comparable<AbstractProviderDescriptor> {
    protected final IConfigurationElement element;
    private int priority = 5;
    private String providerClassName;

    public AbstractProviderDescriptor(IConfigurationElement element) {
        this.element = element;
        this.priority = this.getPriorityValue(this.getAttribute("priority", "low"));
        this.providerClassName = this.getAttribute("providerClass", null);
    }

    public String getProviderClassName() {
        return this.providerClassName;
    }

    private String getAttribute(String name, String defaultValue) {
        String value = this.element.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("The " + name + " attribute is missing");
    }

    public int getPriority() {
        return this.priority;
    }

    private int getPriorityValue(String priorityString) {
        int priorityValue = 5;
        if ("lowest".equals(priorityString)) {
            priorityValue = 20;
        } else if ("low".equals(priorityString)) {
            priorityValue = 10;
        } else if ("high".equals(priorityString)) {
            priorityValue = 1;
        } else if ("highest".equals(priorityString)) {
            priorityValue = 0;
        }
        return priorityValue;
    }

    @Override
    public int compareTo(AbstractProviderDescriptor other) {
        int nombre1 = other.getPriority();
        int nombre2 = this.priority;
        return nombre2 - nombre1;
    }
}

