/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.ActivateRulesCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.DeactivateRulesCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.properties.FiltersPropertySection;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ValidationPropertySection
extends FiltersPropertySection {
    @Override
    protected Collection<?> getAppliedElements() {
        HashSet result = new HashSet();
        if (this.getDiagram() != null) {
            result.addAll(this.getDiagram().getActivatedRules());
        }
        return result;
    }

    @Override
    protected Collection<?> getAvailableElements() {
        HashSet result = new HashSet();
        if (this.getDiagram() != null && this.getDiagram().getDescription() != null && this.getDiagram().getDescription().getValidationSet() != null) {
            result.addAll(this.getDiagram().getDescription().getValidationSet().getAllRules());
        }
        result.removeAll(this.getAppliedElements());
        return result;
    }

    @Override
    protected Composite createFeatureComposite(Composite composite) {
        Composite featureComposite = this.getWidgetFactory().createComposite(composite, 0);
        featureComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        featureComposite.setLayout((Layout)new GridLayout());
        Label featureLabel = this.getWidgetFactory().createLabel(featureComposite, "Activated rules", 0);
        featureLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        return featureComposite;
    }

    @Override
    protected Composite createChoiceComposite(Composite composite) {
        Composite choiceComposite = this.getWidgetFactory().createComposite(composite, 0);
        choiceComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        choiceComposite.setLayout((Layout)new GridLayout());
        Label choiceLabel = this.getWidgetFactory().createLabel(choiceComposite, "Available rules", 0);
        choiceLabel.setLayoutData((Object)new GridData(768));
        return choiceComposite;
    }

    @Override
    protected void newElementsSelected(Collection<?> newElements) {
        this.domain.getCommandStack().execute((Command)new ActivateRulesCommand(this.domain, this.getDiagram(), Lists.newArrayList((Iterable)Iterables.filter(newElements, ValidationRule.class))));
    }

    @Override
    protected void oldElementsRemoved(Collection<?> oldElements) {
        this.domain.getCommandStack().execute((Command)new DeactivateRulesCommand(this.domain, this.getDiagram(), Lists.newArrayList((Iterable)Iterables.filter(oldElements, ValidationRule.class))));
    }
}

