/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.description;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FoldingStyle implements Enumerator
{
    NONE_LITERAL(0, "NONE", "NONE"),
    SOURCE_LITERAL(1, "SOURCE", "SOURCE"),
    TARGET_LITERAL(2, "TARGET", "TARGET");

    public static final int NONE = 0;
    public static final int SOURCE = 1;
    public static final int TARGET = 2;
    private static final FoldingStyle[] VALUES_ARRAY;
    public static final List<FoldingStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FoldingStyle[]{NONE_LITERAL, SOURCE_LITERAL, TARGET_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FoldingStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FoldingStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FoldingStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FoldingStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FoldingStyle get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return SOURCE_LITERAL;
            }
            case 2: {
                return TARGET_LITERAL;
            }
        }
        return null;
    }

    private FoldingStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

