/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.UnexecutableTask;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.EObjectCollectionWrapper;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.tools.internal.command.builders.AbstractDiagramCommandBuilder;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.AbstractVariable;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;

public class SelectionWizardCommandBuilder
extends AbstractDiagramCommandBuilder {
    protected final SelectionWizardDescription tool;
    protected DSemanticDecorator containerView;
    private final Collection<EObject> selectedElements;

    public SelectionWizardCommandBuilder(SelectionWizardDescription tool, DSemanticDecorator containerView, Collection<EObject> selectedElements) {
        this.tool = tool;
        this.containerView = containerView;
        this.selectedElements = selectedElements;
    }

    public final Command buildCommand() {
        DCommand result = this.createEnclosingCommand();
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.containerView);
        if (this.checkGenericToolPrecondition(interpreter)) {
            Option<DDiagram> representation = this.getDDiagram();
            if (representation.some() && this.tool.getInitialOperation() != null && this.tool.getInitialOperation().getFirstModelOperations() != null) {
                this.addPreOperationTasks(result, interpreter);
                result.getTasks().add(this.taskHelper.buildTaskFromModelOperation((DRepresentation)representation.get(), this.containerView.getTarget(), this.tool.getInitialOperation().getFirstModelOperations()));
                this.addPostOperationTasks(result, interpreter);
            }
        } else {
            result.getTasks().add(UnexecutableTask.INSTANCE);
        }
        return result;
    }

    protected void addPreOperationTasks(DCommand command, IInterpreter interpreter) {
        InitInterpreterVariablesTask initInterpreterVariablesTask = this.buildInitVariablesTasks(interpreter);
        command.getTasks().add(initInterpreterVariablesTask);
        this.addDiagramVariable(command, (EObject)this.containerView, interpreter);
    }

    protected void addPostOperationTasks(DCommand command, IInterpreter interpreter) {
        if (this.containerView instanceof DDiagramElement) {
            this.addRefreshTask((DDiagramElement)this.containerView, command, (AbstractToolDescription)this.tool);
        } else if (this.containerView instanceof DDiagram) {
            this.addRefreshTask((DDiagram)this.containerView, command, (AbstractToolDescription)this.tool);
        }
    }

    private InitInterpreterVariablesTask buildInitVariablesTasks(IInterpreter interpreter) {
        Map<AbstractVariable, Object> variables = this.getVariables();
        InitInterpreterVariablesTask initInterpreterVariablesTask = new InitInterpreterVariablesTask(variables, interpreter, this.uiCallback);
        return initInterpreterVariablesTask;
    }

    protected Map<AbstractVariable, Object> getVariables() {
        HashMap<AbstractVariable, Object> variables = new HashMap<AbstractVariable, Object>();
        variables.put((AbstractVariable)this.tool.getContainer(), this.containerView.getTarget());
        variables.put((AbstractVariable)this.tool.getContainerView(), this.containerView);
        if (!this.tool.isMultiple()) {
            variables.put((AbstractVariable)this.tool.getElement(), this.selectedElements.iterator().next());
        } else {
            variables.put((AbstractVariable)this.tool.getElement(), new EObjectCollectionWrapper(this.selectedElements));
        }
        return variables;
    }

    private boolean checkGenericToolPrecondition(IInterpreter interpreter) {
        boolean checked = false;
        InitInterpreterVariablesTask initInterpreterVariablesTask = this.buildInitVariablesTasks(interpreter);
        initInterpreterVariablesTask.execute();
        if (this.containerView instanceof DDiagramElement) {
            checked = this.checkPrecondition((DDiagramElement)this.containerView, (AbstractToolDescription)this.tool);
        } else if (this.containerView instanceof DDiagram) {
            checked = this.checkPrecondition((DDiagram)this.containerView, (AbstractToolDescription)this.tool);
        }
        return checked;
    }

    protected String getEnclosingCommandLabel() {
        return new IdentifiedElementQuery((IdentifiedElement)this.tool).getLabel();
    }

    @Override
    protected Option<DDiagram> getDDiagram() {
        return new EObjectQuery((EObject)this.containerView).getParentDiagram();
    }
}

