/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tree.tools.internal.menu;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.editor.tools.api.menu.AbstractEObjectRefactoringAction;
import org.eclipse.sirius.editor.tools.api.menu.AbstractUndoRecordingCommand;
import org.eclipse.sirius.editor.tree.tools.internal.menu.TreeDescriptionBuilderFromEClass;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.ui.IEditorPart;

class InitializeTreeFromEClass
extends AbstractEObjectRefactoringAction {
    public InitializeTreeFromEClass(IEditorPart editor, ISelection selection) {
        super(editor, selection);
    }

    protected Command buildActionCommand(EditingDomain arg0, Collection<EObject> selection) {
        EObject elementToMove;
        Object result = UnexecutableCommand.INSTANCE;
        this.setSelectionValid(false);
        if (selection.size() == 1 && this.isAbleToInitialize(elementToMove = selection.iterator().next())) {
            this.setSelectionValid(true);
            final TreeDescription treeDesc = (TreeDescription)elementToMove;
            result = new AbstractUndoRecordingCommand(arg0.getResourceSet()){

                protected void doExecute() {
                    EClass eClassToStartFrom = InitializeTreeFromEClass.this.lookForEClass(treeDesc.getDomainClass(), (EList<EPackage>)treeDesc.getMetamodel());
                    new TreeDescriptionBuilderFromEClass(treeDesc, eClassToStartFrom).fillContent();
                }

                protected String getText() {
                    return "Create content from Ecore model";
                }
            };
        }
        return result;
    }

    private boolean isAbleToInitialize(EObject elementToMove) {
        if (elementToMove instanceof TreeDescription && !StringUtil.isEmpty((String)((TreeDescription)elementToMove).getDomainClass())) {
            TreeDescription tree = (TreeDescription)elementToMove;
            if (tree.getMetamodel().size() > 0) {
                EClass foundEClass = this.lookForEClass(tree.getDomainClass(), (EList<EPackage>)tree.getMetamodel());
                if (foundEClass != null) {
                    return true;
                }
                this.setTextIfDisable("Can not find the EClass named :" + tree.getName() + "in the associated metamodels");
            } else {
                this.setTextIfDisable("Unable to initialize tree content if no EClass is explicitely associated with the Tree");
            }
        }
        return false;
    }

    private EClass lookForEClass(String domainClass, EList<EPackage> metamodel) {
        EClass found = null;
        Iterator itPak = metamodel.iterator();
        while (found == null && itPak.hasNext()) {
            EPackage curPack = (EPackage)itPak.next();
            UnmodifiableIterator itClaz = Iterators.filter((Iterator)curPack.eAllContents(), EClass.class);
            while (found == null && itClaz.hasNext()) {
                EClass cur = (EClass)itClaz.next();
                if (!domainClass.equals(cur.getName())) continue;
                return cur;
            }
        }
        return found;
    }
}

