/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.assist;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.fieldassist.IContentProposal;

public class TypeContentProposal
implements IContentProposal {
    private final EClassifier proposal;
    private final String incomplete;

    public TypeContentProposal(EClassifier proposal, String incomplete) {
        this.proposal = proposal;
        this.incomplete = incomplete;
    }

    public String getContent() {
        String content = this.getLabel().substring(this.incomplete.length());
        return content;
    }

    public int getCursorPosition() {
        return this.getLabel().length() + 1;
    }

    public String getDescription() {
        String mmURI;
        String description = this.getLabel();
        String doc = EcoreUtil.getDocumentation((EModelElement)this.proposal);
        if (doc != null) {
            description = String.valueOf(description) + "\n " + doc;
        }
        if ((mmURI = this.proposal.getEPackage().getNsURI()) != null) {
            description = String.valueOf(description) + "\nin " + mmURI;
        }
        if (this.proposal.eResource() != null && this.proposal.eResource().getURI() != null) {
            String resourceURI = this.proposal.eResource().getURI().toString();
            if (mmURI != null && !resourceURI.equals(mmURI)) {
                description = String.valueOf(description) + "\nlocated at " + resourceURI;
            }
        }
        return description;
    }

    public String getLabel() {
        String fullyQualifiedProposal;
        String label = this.proposal.getName();
        if (this.proposal.getEPackage().getName() != null && (fullyQualifiedProposal = String.valueOf(this.proposal.getEPackage().getName()) + "." + this.proposal.getName()).startsWith(this.incomplete)) {
            label = fullyQualifiedProposal;
        }
        return label;
    }
}

