/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.actions;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.tree.DTreeElement;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.ITreeCommandFactory;
import org.eclipse.sirius.tree.business.internal.metamodel.query.DTreeItemInternalQuery;
import org.eclipse.sirius.tree.description.TreeItemDeletionTool;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;

public class DeleteTreeItemsAction
extends Action {
    private static final String DELETE_ITEM = "Delete tree item";
    private static final String DELETE_ITEMS = "Delete tree items";
    private static final String TOOLTIP_ITEM = "Delete the target semantic element";
    private static final String TOOLTIP_ITEMS = "Delete the target semantic elements";
    private final ITreeCommandFactory treeCommandFactory;
    private final TransactionalEditingDomain editingDomain;
    private final Collection<DTreeItem> items = Lists.newArrayList();

    public DeleteTreeItemsAction(TransactionalEditingDomain editingDomain, ITreeCommandFactory treeCommandFactory) {
        super(DELETE_ITEM, DTreeViewerManager.getImageRegistry().getDescriptor("tree/delete"));
        this.editingDomain = editingDomain;
        this.treeCommandFactory = treeCommandFactory;
    }

    public void run() {
        super.run();
        CompoundCommand cc = new CompoundCommand();
        for (DTreeItem item : this.items) {
            cc.append((Command)new DeleteTreeElementRecordingCommand(this.getEditingDomain(), this.getText(), item));
        }
        this.getEditingDomain().getCommandStack().execute((Command)cc);
        this.items.clear();
    }

    private TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    private TreeItemDeletionTool getDeleteTool(DTreeItem treeItem) {
        TreeItemDeletionTool tool = null;
        if (treeItem != null && treeItem.getActualMapping() != null) {
            tool = treeItem.getActualMapping().getDelete();
        }
        return tool;
    }

    public void setItems(Collection<DTreeItem> itemsToDelete) {
        this.items.clear();
        if (itemsToDelete != null) {
            this.items.addAll(itemsToDelete);
        }
        if (this.items.size() == 1) {
            this.setText(DELETE_ITEM);
            this.setToolTipText(TOOLTIP_ITEM);
            TreeItemDeletionTool deleteTool = this.getDeleteTool(this.items.iterator().next());
            if (deleteTool != null) {
                this.setText(new IdentifiedElementQuery((IdentifiedElement)deleteTool).getLabel());
                this.setToolTipText(deleteTool.getDocumentation());
            }
        } else if (this.items.size() > 1) {
            this.setText(DELETE_ITEMS);
            this.setToolTipText(TOOLTIP_ITEMS);
        }
    }

    public boolean canExecute() {
        boolean canExecute = !this.items.isEmpty();
        for (DTreeItem itemToDelete : this.items) {
            boolean bl = canExecute = canExecute && new DTreeItemInternalQuery(itemToDelete).canBeDeleted();
            if (!canExecute) break;
        }
        return canExecute;
    }

    private class DeleteTreeElementRecordingCommand
    extends RecordingCommand {
        private final DTreeItem item;

        public DeleteTreeElementRecordingCommand(TransactionalEditingDomain domain, String label, DTreeItem item) {
            super(domain, label);
            this.item = item;
        }

        protected void doExecute() {
            DeleteTreeItemsAction.this.treeCommandFactory.buildDeleteTreeElement((DTreeElement)this.item).execute();
        }
    }
}

