/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.ui.IEditorPart;

public final class OpenRepresentationAction
extends Action {
    private final DRepresentation representation;
    private final Session session;
    private TransactionalEditingDomain editingDomain;

    public OpenRepresentationAction(String text, ImageDescriptor image, DRepresentation representation, Session session) {
        super(text, image);
        this.representation = representation;
        this.session = session;
        this.editingDomain = session.getTransactionalEditingDomain();
    }

    public OpenRepresentationAction(DRepresentation representation, Session session) {
        this.representation = representation;
        this.session = session;
        this.editingDomain = session.getTransactionalEditingDomain();
    }

    public void run() {
        super.run();
        this.editingDomain.getCommandStack().execute((Command)new AttachEditorRecordingCommand(this.editingDomain));
    }

    private class AttachEditorRecordingCommand
    extends RecordingCommand {
        public AttachEditorRecordingCommand(TransactionalEditingDomain domain) {
            super(domain);
        }

        protected void doExecute() {
            IEditingSession ui = SessionUIManager.INSTANCE.getUISession(OpenRepresentationAction.this.session);
            DialectManager.INSTANCE.refresh(OpenRepresentationAction.this.representation, (IProgressMonitor)new NullProgressMonitor());
            IEditorPart part = DialectUIManager.INSTANCE.openEditor(OpenRepresentationAction.this.session, OpenRepresentationAction.this.representation, (IProgressMonitor)new NullProgressMonitor());
            if (part != null && ui != null) {
                ui.attachEditor((DialectEditor)part);
            }
        }
    }
}

