/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.api.interaction;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.synchronizer.SemanticPartitionInvalidator;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.interaction.DTreeItemUserInteraction;
import org.eclipse.sirius.tree.business.api.query.TreeDescriptionQuery;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.DTreeRefresh;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;

public class DTreeUserInteraction {
    private DTree tree;
    private GlobalContext ctx;

    public DTreeUserInteraction(DTree tree, GlobalContext ctx) {
        this.tree = tree;
        this.ctx = ctx;
    }

    public DTreeUserInteraction refreshContent(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Refresh tree", 1);
            DslCommonPlugin.PROFILER.startWork("Refresh a tree");
            SemanticPartitionInvalidator invalidator = new SemanticPartitionInvalidator();
            DTreeRefresh refresher = new DTreeRefresh(this.tree, new TreeDescriptionQuery(this.tree.getDescription()).getAllDescendantMappings(), invalidator, this.ctx);
            refresher.refresh((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            DslCommonPlugin.PROFILER.stopWork("Refresh a tree");
        }
        finally {
            monitor.done();
        }
        return this;
    }

    public DTreeUserInteraction expandAll() {
        for (DTreeItem child : this.tree.getOwnedTreeItems()) {
            new DTreeItemUserInteraction(child, this.ctx).expandAll();
        }
        return this;
    }

    public DTreeUserInteraction expand() {
        UnmodifiableIterator it = Iterators.filter((Iterator)Iterators.filter((Iterator)this.tree.eAllContents(), DTreeItem.class), (Predicate)new Predicate<DTreeItem>(){

            public boolean apply(DTreeItem input) {
                return !input.isExpanded();
            }
        });
        while (it.hasNext()) {
            new DTreeItemUserInteraction((DTreeItem)it.next(), this.ctx).expand();
        }
        return this;
    }
}

