/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.dialect.common.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.synchronizer.AutomaticCreator;
import org.eclipse.sirius.synchronizer.Mapping;
import org.eclipse.sirius.synchronizer.SemanticPartition;
import org.eclipse.sirius.synchronizer.SemanticPartitions;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeMappingProvider;
import org.eclipse.sirius.tree.description.TreeDescription;
import org.eclipse.sirius.tree.description.TreeItemMapping;

class RTreeMapping
implements Mapping {
    private TreeDescription treeDescription;
    private TreeMappingProvider provider;
    private SemanticPartition semPartition;

    public RTreeMapping(TreeDescription description, TreeMappingProvider provider) {
        this.treeDescription = description;
        this.provider = provider;
        this.semPartition = SemanticPartitions.eAllContents((String)description.getDomainClass());
    }

    public Option<Mapping> getSuper() {
        return Options.newNone();
    }

    public SemanticPartition getSemanticPartition() {
        return this.semPartition;
    }

    public List<Mapping> getChildMappings() {
        ArrayList result = Lists.newArrayList();
        for (TreeItemMapping mapping : this.treeDescription.getSubItemMappings()) {
            result.add(this.provider.getOrCreate(mapping));
        }
        return result;
    }

    public boolean isEnabled() {
        return true;
    }

    public Option<AutomaticCreator> getCreator() {
        return Options.newNone();
    }
}

