/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.business.internal.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.description.TreeItemMapping;
import org.eclipse.sirius.tree.description.TreeItemTool;
import org.eclipse.sirius.tree.description.TreeVariable;

public final class TreeHelper {
    private TreeHelper() {
    }

    public static boolean hasSemanticCandidatesExpression(TreeItemMapping mapping) {
        return !StringUtil.isEmpty((String)mapping.getSemanticCandidatesExpression());
    }

    public static DTree getTree(EObject element) {
        EObject container = element;
        while (container != null) {
            if (container instanceof DTree) {
                return (DTree)container;
            }
            container = container.eContainer();
        }
        return null;
    }

    public static List<DTreeItem> getExpandedItems(DTree tree) {
        ArrayList<DTreeItem> result = new ArrayList<DTreeItem>();
        EList items = tree.getOwnedTreeItems();
        for (DTreeItem item : items) {
            if (item.isExpanded()) {
                result.add(item);
            }
            result.addAll(TreeHelper.getExpandedItems(item));
        }
        return result;
    }

    public static List<DTreeItem> getExpandedItems(DTreeItem parentItem) {
        ArrayList<DTreeItem> result = new ArrayList<DTreeItem>();
        EList<DTreeItem> items = parentItem.getOwnedTreeItems();
        for (DTreeItem item : items) {
            if (item.isExpanded()) {
                result.add(item);
            }
            result.addAll(TreeHelper.getExpandedItems(item));
        }
        return result;
    }

    public static TreeVariable getVariable(TreeItemTool tool, String name) {
        for (TreeVariable tableVariable : tool.getVariables()) {
            if (name == null || !name.equals(tableVariable.getName())) continue;
            return tableVariable;
        }
        return null;
    }
}

