/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.internal.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.api.session.factory.UISessionFactory;
import org.eclipse.sirius.ui.business.internal.session.factory.UISessionFactoryService;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public final class SessionUIManagerImpl
extends SessionManagerListener.Stub
implements SessionUIManager {
    private final Map<Session, IEditingSession> sessionToUISession = new HashMap<Session, IEditingSession>();

    private SessionUIManagerImpl() {
        SessionManager.INSTANCE.addSessionsListener((SessionManagerListener)this);
        for (Session alreadyManagedSession : SessionManager.INSTANCE.getSessions()) {
            if (!alreadyManagedSession.isOpen()) continue;
            this.createAndOpenUiSession(alreadyManagedSession);
        }
    }

    public static SessionUIManager init() {
        return new SessionUIManagerImpl();
    }

    @Override
    public IEditingSession createUISession(Session session) {
        UISessionFactory uiSessionFactory = UISessionFactoryService.INSTANCE.getUISessionFactory();
        IEditingSession editingSession = uiSessionFactory.createUISession(session);
        this.sessionToUISession.put(session, editingSession);
        return editingSession;
    }

    @Override
    public IEditingSession getUISession(Session session) {
        IEditingSession editingSession = this.sessionToUISession.get(session);
        return editingSession;
    }

    @Override
    public void remove(IEditingSession uiSession) {
        ArrayList<Session> toRemove = new ArrayList<Session>();
        for (Map.Entry<Session, IEditingSession> entry : this.sessionToUISession.entrySet()) {
            if (entry.getValue() != uiSession) continue;
            toRemove.add(entry.getKey());
        }
        for (Session session : toRemove) {
            this.sessionToUISession.remove(session);
        }
    }

    @Override
    public Collection<IEditingSession> getUISessions() {
        return this.sessionToUISession.values();
    }

    public void notifyAddSession(Session newSession) {
        this.cleanUISessions();
    }

    public void notifyRemoveSession(Session removedSession) {
        this.cleanUISessions();
    }

    public void notify(Session updated, int notification) {
        super.notify(updated, notification);
        switch (notification) {
            case 7: {
                this.createAndOpenUiSession(updated);
                break;
            }
        }
        this.cleanUISessions();
    }

    protected void cleanUISessions() {
        LinkedList<Session> sessionToRemove = new LinkedList<Session>();
        for (Map.Entry<Session, IEditingSession> mapping : new ArrayList<Map.Entry<Session, IEditingSession>>(this.sessionToUISession.entrySet())) {
            if (mapping.getKey() != null && mapping.getKey().isOpen()) continue;
            sessionToRemove.add(mapping.getKey());
            mapping.getValue().close();
        }
        for (Session session : sessionToRemove) {
            this.sessionToUISession.remove(session);
        }
    }

    private void createAndOpenUiSession(Session openedSession) {
        IEditingSession uiSession = this.getOrCreateUISession(openedSession);
        if (uiSession != null) {
            uiSession.open();
        }
    }

    public IEditingSession findUISession(IEditorInput editorInput) {
        IEditingSession session = null;
        for (IEditingSession editingSession : this.getUISessions()) {
            if (!editingSession.isSessionFor(editorInput)) continue;
            session = editingSession;
        }
        if (session == null) {
            this.keyFromInput(editorInput);
        }
        return session;
    }

    private String keyFromInput(IEditorInput input) {
        Object uri;
        String result = null;
        if (input instanceof URIEditorInput) {
            uri = ((URIEditorInput)input).getURI();
            URI deresolved = uri.deresolve(URI.createURI((String)"platform:/resource/"));
            String workspacePAth = "/" + deresolved.path();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(workspacePAth));
            if (file != null && file.isAccessible() && file.exists()) {
                String filePath = file.getLocation().toString();
                if (filePath.startsWith("/")) {
                    filePath = filePath.substring(1);
                }
                result = filePath;
            }
            if (result == null) {
                String path = uri.path();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                result = path;
            }
        }
        if (result == null && input instanceof IPathEditorInput) {
            result = ((IPathEditorInput)input).getPath().toString();
        }
        if (result == null && input instanceof FileEditorInput) {
            uri = ((FileEditorInput)input).getURI();
            String path = ((java.net.URI)uri).getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            result = path;
        }
        if (result == null) {
            result = input.toString();
        }
        return result;
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    @Override
    public IEditingSession getOrCreateUISession(Session session) {
        IEditingSession uiSession = this.getUISession(session);
        if (uiSession == null) {
            uiSession = this.createUISession(session);
        }
        return uiSession;
    }
}

