/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.api.ui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.tools.api.command.ui.RefreshFilterManager;
import org.eclipse.sirius.tools.api.ui.PostRefreshCommandFactory;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class RefreshEditorsPrecommitListener
implements ModelChangeTrigger,
SessionListener {
    public static final int REFRESH_EDITOR_PRIORITY = 1;
    public static final NotificationFilter IS_IMPACTING = new NotificationFilter.Custom(){

        public boolean matches(Notification notification) {
            return !notification.isTouch();
        }
    };
    TransactionalEditingDomain transactionalEditingDomain;
    private boolean forceRefresh;
    private final Collection<DRepresentation> representationsToForceRefresh = new ArrayList<DRepresentation>();
    private final Collection<PostRefreshCommandFactory> postRefreshCommandFactories = new ArrayList<PostRefreshCommandFactory>();

    public RefreshEditorsPrecommitListener(TransactionalEditingDomain transactionalEditingDomain) {
        this.transactionalEditingDomain = transactionalEditingDomain;
    }

    @Override
    public int priority() {
        return 1;
    }

    @Override
    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        Option<? extends Command> optionCommand;
        boolean impactingNotification;
        Command result = null;
        if (this.needsRefresh() && ((impactingNotification = this.isImpactingNotification(notifications)) || !this.representationsToForceRefresh.isEmpty()) && (optionCommand = this.getRefreshOpennedRepresentationsCommand(impactingNotification)).some()) {
            result = (Command)optionCommand.get();
        }
        this.setForceRefresh(false);
        this.representationsToForceRefresh.clear();
        return Options.newSome(result);
    }

    private boolean isImpactingNotification(Collection<Notification> notifications) {
        boolean isImpactingNotification = false;
        for (Notification notification : notifications) {
            EObject eObjectNotifier;
            Resource notifierResource;
            Object notifier = notification.getNotifier();
            if (!(notifier instanceof EObject) || (notifierResource = (eObjectNotifier = (EObject)notifier).eResource()) == null || notifierResource.getContents().get(0) instanceof DAnalysis) continue;
            isImpactingNotification = true;
            break;
        }
        return isImpactingNotification;
    }

    private Option<? extends Command> getRefreshOpennedRepresentationsCommand(boolean isChanged) {
        Option result = Options.newNone();
        LinkedHashSet<DRepresentation> representationsToRefresh = new LinkedHashSet<DRepresentation>();
        if (isChanged) {
            representationsToRefresh.addAll(RefreshFilterManager.INSTANCE.getOpenedRepresantationsToRefresh());
        }
        representationsToRefresh.addAll(this.representationsToForceRefresh);
        for (DRepresentation rep : Lists.newArrayList(representationsToRefresh)) {
            if (this.transactionalEditingDomain != TransactionUtil.getEditingDomain((EObject)rep)) {
                representationsToRefresh.remove(rep);
                continue;
            }
            if (!(rep instanceof DSemanticDecorator) || this.transactionalEditingDomain == TransactionUtil.getEditingDomain((EObject)((DSemanticDecorator)((Object)rep)).getTarget())) continue;
            representationsToRefresh.remove(rep);
        }
        if (!representationsToRefresh.isEmpty()) {
            CompoundCommand cc = new CompoundCommand();
            cc.append((Command)new RefreshRepresentationsCommand(this.transactionalEditingDomain, (IProgressMonitor)new NullProgressMonitor(), representationsToRefresh));
            for (PostRefreshCommandFactory listener : this.postRefreshCommandFactories) {
                cc.appendIfCanExecute(listener.getPostCommandToExecute(this.transactionalEditingDomain, representationsToRefresh));
            }
            this.postRefreshCommandFactories.clear();
            result = Options.newSome((Object)cc);
        }
        return result;
    }

    public boolean isForceRefresh() {
        return this.forceRefresh;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    private boolean needsRefresh() {
        return !(!this.isForceRefresh() && !this.isAutoRefresh() || RefreshFilterManager.INSTANCE.getOpenedRepresantationsToRefresh().isEmpty() && this.representationsToForceRefresh.isEmpty());
    }

    private boolean isAutoRefresh() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false, null);
    }

    @Override
    public void notify(int changeKind) {
        if (5 == changeKind && this.needsRefresh()) {
            this.setForceRefresh(false);
            Option<? extends Command> optionCommand = this.getRefreshOpennedRepresentationsCommand(true);
            this.representationsToForceRefresh.clear();
            if (optionCommand.some()) {
                this.transactionalEditingDomain.getCommandStack().execute((Command)optionCommand.get());
            }
        }
    }

    public void addRepresentationToForceRefresh(DRepresentation representation) {
        if (!this.representationsToForceRefresh.contains(representation)) {
            this.representationsToForceRefresh.add(representation);
        }
    }

    public void addPostRefreshCommandFactory(PostRefreshCommandFactory factory) {
        this.postRefreshCommandFactories.add(factory);
    }
}

