/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.draw2d;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.swt.graphics.Color;

public class ColoredLabel
extends Figure {
    Color currentColor = ColorConstants.black;
    String currentText;
    Figure currentLine;

    public ColoredLabel() {
        this.setLayoutManager((LayoutManager)new ToolbarLayout(false));
    }

    public void setColor(Color c) {
        if (c != this.currentColor) {
            this.flush();
            this.currentColor = c;
        }
    }

    public void addText(String s) {
        this.currentText = this.currentText == null ? s : String.valueOf(this.currentText) + s;
    }

    public void addTextLine(String s) {
        this.addText(s);
        this.addNewline();
    }

    public void addText(Color c, String s) {
        this.setColor(c);
        this.addText(s);
    }

    public void addTextLine(Color c, String s) {
        this.setColor(c);
        this.addText(s);
        this.addNewline();
    }

    public void addNewline() {
        this.flush();
        this.currentLine = null;
    }

    public void flush() {
        if (this.currentText != null) {
            if (this.currentLine == null) {
                this.currentLine = new Figure();
                this.currentLine.setLayoutManager((LayoutManager)new ToolbarLayout(true));
                this.add((IFigure)this.currentLine);
            }
            Label label = new Label(this.currentText);
            label.setForegroundColor(this.currentColor);
            label.setFont(this.getFont());
            this.currentLine.add((IFigure)label);
            this.currentText = null;
        }
    }
}

