/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.functions;

import org.eclipse.stardust.ide.simulation.ui.curves.data.DataProviderForDoubleFunction;

public class NormalDistribution
implements DataProviderForDoubleFunction.Function {
    double mju;
    double sigmasqr;

    public NormalDistribution(double mju, double sigmasqr) {
        this.mju = mju;
        this.sigmasqr = sigmasqr;
    }

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    @Override
    public double f(double x) {
        double p1 = 1.0 / Math.sqrt(2.0 * this.sigmasqr * Math.PI);
        double p2 = (x - this.mju) * (x - this.mju) / (-2.0 * this.sigmasqr);
        return p1 * Math.exp(p2);
    }

    public String toString() {
        return "\u03bc=" + this.mju + " \u03c3\u00b2=" + this.sigmasqr;
    }
}

