/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.AxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.StaticAxisLabeling;
import org.eclipse.stardust.ide.simulation.ui.curves.swtutil.GCDrawingUtils;
import org.eclipse.swt.graphics.Point;

public class YAxisLayer
implements Layer {
    private static final AxisLabeling NO_LABELING = new StaticAxisLabeling(0.0, 0.0, 0.0, null);
    String variable;
    String unit;
    AxisLabeling labeling;
    boolean arrow;

    public YAxisLayer(String variable, String unit, double smallTicks, double largeTicks, double scaleTicks, String scaleFormat, boolean arrow) {
        this.variable = variable;
        this.unit = unit;
        this.labeling = new StaticAxisLabeling(smallTicks, largeTicks, scaleTicks, scaleFormat);
        this.arrow = arrow;
    }

    public YAxisLayer(String variable, String unit, AxisLabeling labeling, boolean arrow) {
        this.variable = variable;
        this.unit = unit;
        this.labeling = labeling != null ? labeling : NO_LABELING;
        this.arrow = arrow;
    }

    @Override
    public void draw(Graphics gc, Metrics metrics, Configuration configuration) {
        GCDrawingUtils gcutils;
        Coord2D c0 = new Coord2D(0.0, metrics.getValueRectangle().getMinCorner().getY());
        Coord2D cn = new Coord2D(0.0, metrics.getValueRectangle().getMaxCorner().getY());
        Point p0 = Coord2D.model2swt(metrics.transposeToCanvas(c0));
        Point pn = Coord2D.model2swt(metrics.transposeToCanvas(cn));
        this.labeling.update(cn.minus(c0).getY(), pn.y - p0.y);
        int arrowSize = configuration.getArrowSize();
        gc.pushState();
        gc.setForegroundColor(configuration.getAxesColorObject());
        gc.drawLine(p0.x, p0.y, pn.x, pn.y);
        if (this.arrow) {
            gc.drawLine(pn.x - arrowSize, pn.y + arrowSize, pn.x, pn.y);
            gc.drawLine(pn.x + arrowSize, pn.y + arrowSize, pn.x, pn.y);
        }
        if (this.labeling.hasSmallTicks()) {
            this.drawTicks(gc, metrics, c0, cn, new Coord2D(0.0, this.labeling.getSmallTicks()), configuration.getSmallTickSize());
        }
        if (this.labeling.hasLargeTicks()) {
            this.drawTicks(gc, metrics, c0, cn, new Coord2D(0.0, this.labeling.getLargeTicks()), configuration.getLargeTickSize());
        }
        if (this.labeling.hasScaleTicks()) {
            gc.setFont(configuration.getScaleFontObject());
            this.drawScale(gc, metrics, c0, cn, new Coord2D(0.0, this.labeling.getScaleTicks()), configuration.getTextOffset());
        }
        if (this.variable != null) {
            gcutils = new GCDrawingUtils(gc);
            gcutils.drawText(this.variable, pn.x - arrowSize, pn.y, 131072);
        }
        if (this.unit != null) {
            gcutils = new GCDrawingUtils(gc);
            gcutils.drawText(this.unit, pn.x + arrowSize, pn.y, 16384);
        }
        gc.popState();
    }

    public void drawTicks(Graphics gc, Metrics metrics, Coord2D min, Coord2D max, Coord2D step, int size) {
        Point p;
        Coord2D c = new Coord2D(0.0, 0.0);
        while (c.getY() < max.getY()) {
            p = Coord2D.model2swt(metrics.transposeToCanvas(c));
            gc.drawLine(p.x - size, p.y, p.x + size, p.y);
            c = c.plus(step);
        }
        c = new Coord2D(0.0, -step.getY());
        while (c.getY() > min.getY()) {
            p = Coord2D.model2swt(metrics.transposeToCanvas(c));
            gc.drawLine(p.x - size, p.y, p.x + size, p.y);
            c = c.minus(step);
        }
    }

    public void drawScale(Graphics gc, Metrics metrics, Coord2D min, Coord2D max, Coord2D step, int offset) {
        Point p;
        GCDrawingUtils gcutils = new GCDrawingUtils(gc);
        Coord2D c = new Coord2D(0.0, 0.0);
        while (c.getY() < max.getY()) {
            p = Coord2D.model2swt(metrics.transposeToCanvas(c));
            gcutils.drawText(this.labeling.format(c.getY()), p.x - offset, p.y, 131072);
            c = c.plus(step);
        }
        c = new Coord2D(0.0, -step.getY());
        while (c.getY() > min.getY()) {
            p = Coord2D.model2swt(metrics.transposeToCanvas(c));
            gcutils.drawText(this.labeling.format(c.getY()), p.x - offset, p.y, 131072);
            c = c.minus(step);
        }
    }

    @Override
    public Rectangle2D getBounds() {
        return null;
    }
}

