/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.spi;

import org.eclipse.stardust.common.Direction;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.spi.AccessPoint;
import org.eclipse.stardust.model.spi.DataValidator;

public class BridgeObject {
    private final Class endClass;
    private final Direction direction;

    public static BridgeObject getBridge(AccessPoint ap, String path, Direction direction) {
        String validatorClass = ap.getType().getStringAttribute("carnot:engine:validator");
        if (!StringUtils.isEmpty((String)validatorClass)) {
            DataValidator validator = (DataValidator)Reflect.getInstance((String)validatorClass);
            return validator.getBridgeObject(ap, path, direction);
        }
        return new BridgeObject(Object.class, direction);
    }

    public BridgeObject(Class endClass, Direction direction) {
        this.endClass = endClass;
        this.direction = direction;
    }

    public Class getEndClass() {
        return this.endClass;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean acceptAssignmentFrom(BridgeObject rhs) {
        if (this.direction == Direction.OUT) {
            return false;
        }
        if (rhs.direction == Direction.IN) {
            return false;
        }
        return Reflect.isAssignable((Class)this.endClass, (Class)rhs.endClass);
    }

    public static boolean isValidMapping(Direction direction, AccessPoint lhsPoint, String lhsPath, AccessPoint rhsPoint, String rhsPath) {
        BridgeObject rightBridge;
        BridgeObject leftBridge;
        try {
            leftBridge = BridgeObject.getBridge(lhsPoint, lhsPath, Direction.IN.equals((Object)direction) ? Direction.IN : Direction.OUT);
        }
        catch (Exception exception) {
            return false;
        }
        try {
            rightBridge = BridgeObject.getBridge(rhsPoint, rhsPath, Direction.OUT.equals((Object)direction) ? Direction.IN : Direction.OUT);
        }
        catch (Exception exception) {
            return false;
        }
        return Direction.IN.equals((Object)direction) ? leftBridge.acceptAssignmentFrom(rightBridge) : rightBridge.acceptAssignmentFrom(leftBridge);
    }
}

