/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.core.compatibility.el.BooleanExpression;
import org.eclipse.stardust.engine.core.compatibility.el.CombineOperation;
import org.eclipse.stardust.engine.core.compatibility.el.ComparisonOperation;
import org.eclipse.stardust.engine.core.compatibility.el.ConstantExpression;
import org.eclipse.stardust.engine.core.compatibility.el.DereferencePath;
import org.eclipse.stardust.engine.core.compatibility.el.Interpreter;
import org.eclipse.stardust.engine.core.compatibility.el.SyntaxError;
import org.eclipse.stardust.engine.core.compatibility.el.ValueExpression;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.Model_Messages;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.UnsupportedElSyntaxException;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

public class ElUtils {
    private static final ContextFactory jsContextFactory = ContextFactory.getGlobal();

    public static Map xrefData(String expression) throws SyntaxError {
        HashMap result = new HashMap();
        ElUtils.xrefData(Interpreter.parse((String)expression), result);
        return result;
    }

    public static int getRefCount(String dataId, Map xrefs) {
        return xrefs.containsKey(dataId) ? ((List)xrefs.get(dataId)).size() : 0;
    }

    public static BooleanExpression getLhsExpression(CombineOperation term) {
        return (BooleanExpression)Reflect.getFieldValue((Object)term, (String)"lhsExpression");
    }

    public static BooleanExpression getRhsExpression(CombineOperation term) {
        return (BooleanExpression)Reflect.getFieldValue((Object)term, (String)"rhsExpression");
    }

    public static ValueExpression getLhsOperand(ComparisonOperation term) {
        return (ValueExpression)Reflect.getFieldValue((Object)term, (String)"lhsValue");
    }

    public static ValueExpression getRhsOperand(ComparisonOperation term) {
        return (ValueExpression)Reflect.getFieldValue((Object)term, (String)"rhsValue");
    }

    public static String getDataId(DereferencePath derefExpression) {
        return (String)Reflect.getFieldValue((Object)derefExpression, (String)"baseReference");
    }

    public static String getDerefExpression(DereferencePath derefExpression) {
        return (String)Reflect.getFieldValue((Object)derefExpression, (String)"accessPath");
    }

    private static void xrefData(BooleanExpression expression, Map xrefs) {
        if (expression instanceof CombineOperation) {
            CombineOperation parsedExpressions = (CombineOperation)expression;
            ElUtils.xrefData(ElUtils.getLhsExpression(parsedExpressions), xrefs);
            ElUtils.xrefData(ElUtils.getRhsExpression(parsedExpressions), xrefs);
        } else if (expression instanceof ComparisonOperation) {
            ComparisonOperation parsedExpressions = (ComparisonOperation)expression;
            ElUtils.xrefData(ElUtils.getLhsOperand(parsedExpressions), xrefs);
            ElUtils.xrefData(ElUtils.getRhsOperand(parsedExpressions), xrefs);
        } else {
            throw new InternalException(MessageFormat.format(Model_Messages.EXC_UNSUPPORTED_BOOLEAN_EXPRESSION_NULL, expression));
        }
    }

    private static void xrefData(ValueExpression expression, Map xrefs) {
        if (!(expression instanceof ConstantExpression)) {
            if (expression instanceof DereferencePath) {
                String dataId = ElUtils.getDataId((DereferencePath)expression);
                ArrayList<DereferencePath> xref = (ArrayList<DereferencePath>)xrefs.get(dataId);
                if (xref == null) {
                    xref = new ArrayList<DereferencePath>();
                    xrefs.put(dataId, xref);
                }
                xref.add((DereferencePath)expression);
            } else {
                throw new InternalException(MessageFormat.format(Model_Messages.EXC_UNSUPPORTED_BOOLEAN_EXPRESSION_NULL, expression));
            }
        }
    }

    public static ScriptOrFnNode parseJsExpressions(String expression) {
        Context cx = jsContextFactory.enter();
        try {
            CompilerEnvirons compilerEnv = new CompilerEnvirons();
            compilerEnv.setGeneratingSource(true);
            compilerEnv.initFromContext(cx);
            ErrorReporter compilationErrorReporter = null;
            if (compilationErrorReporter == null) {
                compilationErrorReporter = compilerEnv.getErrorReporter();
            }
            Parser p = new Parser(compilerEnv, compilationErrorReporter);
            ScriptOrFnNode scriptOrFnNode = p.parse(expression, "expression", 1);
            return scriptOrFnNode;
        }
        finally {
            Context.exit();
        }
    }

    public static Map<String, List<Node>> xrefData4Js(String expression) {
        ScriptOrFnNode ast = ElUtils.parseJsExpressions(expression);
        HashMap<String, List<Node>> dataIds = new HashMap<String, List<Node>>();
        if (ast.hasChildren()) {
            Stack<Node> backtrack = new Stack<Node>();
            Node astNode = ast.getFirstChild();
            do {
                if (2 == astNode.getType()) {
                    throw new UnsupportedElSyntaxException(Model_Messages.EXC_WITH_IS_NOT_SUPPORTED);
                }
                if (39 == astNode.getType()) {
                    ArrayList<Node> refs = (ArrayList<Node>)dataIds.get(astNode.getString());
                    if (refs == null) {
                        refs = new ArrayList<Node>();
                        dataIds.put(astNode.getString(), refs);
                    }
                    refs.add(astNode);
                }
                if (astNode.hasChildren()) {
                    backtrack.push(astNode);
                    astNode = astNode.getFirstChild();
                } else {
                    astNode = astNode.getNext();
                }
                while (astNode == null && !backtrack.isEmpty()) {
                    astNode = ((Node)backtrack.pop()).getNext();
                }
            } while (astNode != null);
        }
        return dataIds;
    }

    public static void updateTransitionConditions(DataType dataType, String oldValue, String newValue) {
        ModelType modelType = (ModelType)dataType.eContainer();
        Iterator iter = modelType.getProcessDefinition().iterator();
        while (iter.hasNext()) {
            for (TransitionType transition : ((ProcessDefinitionType)iter.next()).getTransition()) {
                String expression = transition.getExpression() == null ? null : ModelUtils.getCDataString(transition.getExpression().getMixed());
                ElUtils.patchJsExpressions(expression, oldValue, newValue);
                String newExpression = ElUtils.patchJsExpressions(expression, oldValue, newValue);
                ModelUtils.setCDataString(transition.getExpression().getMixed(), newExpression);
            }
        }
    }

    public static String patchExpressions(String expression, String oldId, String newId) throws SyntaxError {
        String result = expression;
        int currentPos = 0;
        int startOfDataId = result.indexOf(oldId, currentPos);
        while (-1 != startOfDataId) {
            Map dataRefCount = ElUtils.xrefData(result);
            int nIdRefs = ElUtils.getRefCount(oldId, dataRefCount);
            int nMangledIdRefs = ElUtils.getRefCount(newId, dataRefCount);
            StringBuffer buffer = new StringBuffer(result);
            buffer.replace(startOfDataId, startOfDataId + oldId.length(), newId);
            try {
                Map newRefCount = ElUtils.xrefData(buffer.toString());
                int nIdRefsNow = ElUtils.getRefCount(oldId, newRefCount);
                int nMangledIdRefsNow = ElUtils.getRefCount(newId, newRefCount);
                if (nIdRefs == 1 + nIdRefsNow && 1 + nMangledIdRefs == nMangledIdRefsNow) {
                    currentPos = startOfDataId + newId.length();
                    result = buffer.toString();
                } else {
                    currentPos = 1 + startOfDataId;
                }
            }
            catch (SyntaxError syntaxError) {
                currentPos = 1 + startOfDataId;
            }
            startOfDataId = currentPos < result.length() ? result.indexOf(oldId, currentPos) : -1;
        }
        return result;
    }

    public static String patchJsExpressions(String expression, String oldId, String newId) {
        String result = expression;
        int currentPos = 0;
        int startOfDataId = result.indexOf(oldId, currentPos);
        while (-1 != startOfDataId) {
            Map<String, List<Node>> dataRefCount = ElUtils.xrefData4Js(result);
            int nIdRefs = ElUtils.getRefCount(oldId, dataRefCount);
            int nMangledIdRefs = ElUtils.getRefCount(newId, dataRefCount);
            StringBuffer buffer = new StringBuffer(result);
            buffer.replace(startOfDataId, startOfDataId + oldId.length(), newId);
            try {
                Map<String, List<Node>> newRefCount = ElUtils.xrefData4Js(buffer.toString());
                int nIdRefsNow = ElUtils.getRefCount(oldId, newRefCount);
                int nMangledIdRefsNow = ElUtils.getRefCount(newId, newRefCount);
                if (nIdRefs == 1 + nIdRefsNow && 1 + nMangledIdRefs == nMangledIdRefsNow) {
                    currentPos = startOfDataId + newId.length();
                    result = buffer.toString();
                } else {
                    currentPos = 1 + startOfDataId;
                }
            }
            catch (Exception exception) {
                currentPos = 1 + startOfDataId;
            }
            startOfDataId = currentPos < result.length() ? result.indexOf(oldId, currentPos) : -1;
        }
        return result;
    }

    private ElUtils() {
    }
}

