/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.io.ByteArrayInputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.api.dto.AuditTrailPersistence;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.DocumentRoot;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IAttributeCategory;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.Model_Messages;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerTypeType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataInitializer;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.CarnotWorkflowModelResourceImpl;
import org.eclipse.stardust.model.xpdl.spi.IResourceResolver;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.BasicTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.DeclaredTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.XpdlUtil;
import org.eclipse.xsd.XSDSchema;

public class ModelUtils {
    private static XpdlFactory xpdlFactory = XpdlFactory.eINSTANCE;
    public static final Comparator<Object> IDENTIFIABLE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object lhs, Object rhs) {
            String rhsKey;
            String lhsKey;
            IIdentifiableElement rhsIie;
            IIdentifiableElement lhsIie = lhs instanceof IIdentifiableElement ? (IIdentifiableElement)lhs : null;
            IIdentifiableElement iIdentifiableElement = rhsIie = rhs instanceof IIdentifiableElement ? (IIdentifiableElement)rhs : null;
            String string = lhsIie == null ? null : (lhsKey = StringUtils.isEmpty((String)lhsIie.getName()) ? lhsIie.getId() : lhsIie.getName());
            String string2 = rhsIie == null ? null : (rhsKey = StringUtils.isEmpty((String)rhsIie.getName()) ? rhsIie.getId() : rhsIie.getName());
            if (lhsKey != null) {
                return rhsKey == null ? 1 : lhsKey.compareToIgnoreCase(rhsKey);
            }
            return -1;
        }
    };

    private static <T extends EObject> T findContained(EObject object, Class<T> clz) {
        if (object != null) {
            for (EObject content : object.eContents()) {
                if (!clz.isInstance(content)) continue;
                return (T)((EObject)clz.cast(content));
            }
        }
        return null;
    }

    private static <T extends EObject> T findContainer(EObject object, Class<T> clz) {
        while (object != null) {
            if (clz.isInstance(object)) {
                return (T)((EObject)clz.cast(object));
            }
            object = object.eContainer();
        }
        return null;
    }

    public static ModelType findContainingModel(EObject element) {
        if (element == null) {
            return null;
        }
        ModelType model = ModelUtils.findContainer(element, ModelType.class);
        return model == null ? ModelUtils.findContained(ModelUtils.getTopContainer(element), ModelType.class) : model;
    }

    private static EObject getTopContainer(EObject element) {
        while (element.eContainer() != null) {
            element = element.eContainer();
        }
        return element;
    }

    public static DiagramType findContainingDiagram(IGraphicalObject graphicalObject) {
        return ModelUtils.findContainer(graphicalObject, DiagramType.class);
    }

    public static ProcessDefinitionType findContainingProcess(EObject element) {
        return ModelUtils.findContainer(element, ProcessDefinitionType.class);
    }

    public static PoolSymbol findContainingPool(EObject element) {
        return ModelUtils.findContainer(element, PoolSymbol.class);
    }

    public static ApplicationType findContainingApplication(EObject element) {
        return ModelUtils.findContainer(element, ApplicationType.class);
    }

    public static ActivityType findContainingActivity(EObject element) {
        return ModelUtils.findContainer(element, ActivityType.class);
    }

    public static EventHandlerType findContainingEventHandlerType(EObject element) {
        return ModelUtils.findContainer(element, EventHandlerType.class);
    }

    public static TriggerType findContainingTriggerType(EObject element) {
        return ModelUtils.findContainer(element, TriggerType.class);
    }

    public static long getElementOid(IModelElement element, ModelType model) {
        long elementOid = element.isSetElementOid() ? element.getElementOid() : ModelUtils.getMaxUsedOid(model) + 1L;
        return elementOid;
    }

    public static long getMaxUsedOid(ModelType model) {
        long maxOid = 0L;
        if (model.isSetOid()) {
            maxOid = model.getOid();
        }
        TreeIterator i = model.eAllContents();
        while (i.hasNext()) {
            EObject obj = (EObject)i.next();
            if (!(obj instanceof IModelElement) || !((IModelElement)obj).isSetElementOid()) continue;
            maxOid = Math.max(maxOid, ((IModelElement)obj).getElementOid());
        }
        return maxOid;
    }

    public static ActivityType findRootActivity(ProcessDefinitionType process) {
        ActivityType result = null;
        for (ActivityType activity : process.getActivity()) {
            if (!activity.getInTransitions().isEmpty()) continue;
            if (result == null) {
                result = activity;
                continue;
            }
            result = null;
            break;
        }
        return result;
    }

    public static DataType findData(IModelElement context, String dataId) {
        DataType result = null;
        ModelType model = ModelUtils.findContainingModel(context);
        if (model != null) {
            result = ModelUtils.findIdentifiableElement(model.getData(), dataId);
        }
        return result;
    }

    public static DescriptionType createDescription(String description) {
        if (description == null) {
            return null;
        }
        DescriptionType descriptionType = CarnotWorkflowModelFactory.eINSTANCE.createDescriptionType();
        ModelUtils.setCDataString(descriptionType.getMixed(), description);
        return descriptionType;
    }

    public static String getDescriptionText(DescriptionType desc) {
        if (desc == null) {
            return null;
        }
        return ModelUtils.getCDataString(desc.getMixed());
    }

    public static void setCDataString(FeatureMap mixed, String description) {
        ModelUtils.setCDataString(mixed, description, false);
    }

    public static void setCDataString(FeatureMap mixed, String text, boolean normalizeCrLf) {
        if (normalizeCrLf) {
            text = StringUtils.replace((String)text, (String)"\r\n", (String)"\n");
        }
        XpdlUtil.setText(mixed, text, true);
    }

    public static String getCDataString(FeatureMap featureMap) {
        return XpdlUtil.getText(featureMap, true);
    }

    public static IIdentifiableElement findIdentifiableElement(EObject parent, EStructuralFeature feature, String id) {
        EObject result = ModelUtils.findElementById(parent, feature, id);
        return result instanceof IIdentifiableElement ? (IIdentifiableElement)result : null;
    }

    public static EObject findElementById(EObject parent, EStructuralFeature feature, String id) {
        Object value;
        if (parent != null && (value = parent.eGet(feature)) instanceof List) {
            List domain = (List)value;
            return (EObject)ModelUtils.findElementById(domain, id);
        }
        return null;
    }

    public static <T extends IIdentifiableElement> T findIdentifiableElement(List<? extends T> domain, String id) {
        IIdentifiableElement result = (IIdentifiableElement)ModelUtils.findElementById(domain, id);
        return (T)(result instanceof IIdentifiableElement ? result : null);
    }

    public static EObject findElementById(List<?> domain, IIdentifiableElement object) {
        String id = object.getId();
        EObject result = null;
        for (Object candidate : domain) {
            DirectionType direction;
            String candidateId;
            String string = candidate instanceof IIdentifiableElement ? ((IIdentifiableElement)candidate).getId() : (candidateId = candidate instanceof TypeDeclarationType ? ((TypeDeclarationType)candidate).getId() : null);
            if (object instanceof DataMappingType) {
                DirectionType direction_;
                direction = ((DataMappingType)object).getDirection();
                if (!(candidate instanceof DataMappingType) || !direction.equals((Object)(direction_ = ((DataMappingType)candidate).getDirection()))) continue;
            }
            if (object instanceof AccessPointType) {
                DirectionType candidateDirection;
                direction = ((AccessPointType)object).getDirection();
                if (!(candidate instanceof AccessPointType) || !direction.equals((Object)(candidateDirection = ((AccessPointType)candidate).getDirection()))) continue;
            }
            if (!CompareHelper.areEqual((Object)id, (Object)candidateId)) continue;
            result = (EObject)candidate;
            break;
        }
        return result;
    }

    public static <T> T findElementById(List<? extends T> domain, String id) {
        T result = null;
        int i = 0;
        while (i < domain.size()) {
            String candidateId;
            T candidate = domain.get(i);
            String string = candidate instanceof IIdentifiableElement ? ((IIdentifiableElement)candidate).getId() : (candidateId = candidate instanceof TypeDeclarationType ? ((TypeDeclarationType)candidate).getId() : null);
            if (CompareHelper.areEqual((Object)id, (Object)candidateId)) {
                result = candidate;
                break;
            }
            ++i;
        }
        return result;
    }

    public static List<ITypedElement> findMetaTypeInstances(List<? extends IModelElement> domain, String metaTypeId) {
        if (domain == null || domain.isEmpty()) {
            return Collections.emptyList();
        }
        List result = CollectionUtils.newList((int)domain.size());
        for (IModelElement iModelElement : domain) {
            IMetaType metaType;
            if (!(iModelElement instanceof ITypedElement) || (metaType = ((ITypedElement)((Object)iModelElement)).getMetaType()) == null || !CompareHelper.areEqual((Object)metaTypeId, (Object)metaType.getId())) continue;
            result.add((ITypedElement)((Object)iModelElement));
        }
        return result;
    }

    public static void addSymbols(Set<INodeSymbol> set, ISymbolContainer container, EReference ref, EStructuralFeature feat, String refId) {
        if (container == null) {
            return;
        }
        for (ISymbolContainer iSymbolContainer : ModelUtils.getSubContainers(container)) {
            ModelUtils.addSymbols(set, iSymbolContainer, ref, feat, refId);
        }
        List list = (List)container.eGet((EStructuralFeature)ref);
        for (INodeSymbol symbol : list) {
            if (refId != null && !refId.equals(ModelUtils.getStringValue(symbol.eGet(feat)))) continue;
            set.add(symbol);
        }
    }

    public static void addSymbols(Set<INodeSymbol> set, ISymbolContainer container, EReference ref, EStructuralFeature feat, IModelElement element) {
        if (container != null) {
            for (ISymbolContainer iSymbolContainer : ModelUtils.getSubContainers(container)) {
                ModelUtils.addSymbols(set, iSymbolContainer, ref, feat, element);
            }
            List list = (List)container.eGet((EStructuralFeature)ref);
            for (INodeSymbol symbol : list) {
                if (element != symbol.eGet(feat)) continue;
                set.add(symbol);
            }
        }
    }

    public static List<? extends ISymbolContainer> getSubContainers(ISymbolContainer container) {
        EList subContainers = Collections.emptyList();
        if (container instanceof DiagramType) {
            subContainers = ((DiagramType)container).getPoolSymbols();
        } else if (container instanceof PoolSymbol) {
            subContainers = ((PoolSymbol)container).getLanes();
        } else if (container instanceof LaneSymbol) {
            subContainers = ((LaneSymbol)container).getChildLanes();
        }
        return subContainers;
    }

    private static String getStringValue(Object object) {
        return object == null ? null : object.toString();
    }

    public static DataTypeType getDataType(IModelElement element, String typeId) {
        return (DataTypeType)ModelUtils.findIdentifiableElement(ModelUtils.findContainingModel(element), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_DataType(), typeId);
    }

    public static ApplicationTypeType getApplicationType(IModelElement element, String typeId) {
        return (ApplicationTypeType)ModelUtils.findIdentifiableElement(ModelUtils.findContainingModel(element), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationType(), typeId);
    }

    public static TypeDeclarationType getTypeDeclaration(IExtensibleElement element, String typeId) {
        return ModelUtils.getTypeDeclaration(ModelUtils.findContainingModel(element), typeId);
    }

    public static TypeDeclarationType getTypeDeclaration(IModelElement element, String typeId) {
        return ModelUtils.getTypeDeclaration(ModelUtils.findContainingModel(element), typeId);
    }

    private static TypeDeclarationType getTypeDeclaration(ModelType model, String typeId) {
        return ModelUtils.findElementById(model.getTypeDeclarations().getTypeDeclaration(), typeId);
    }

    public static ApplicationContextTypeType getApplicationContextType(IModelElement element, String typeId) {
        return (ApplicationContextTypeType)ModelUtils.findIdentifiableElement(ModelUtils.findContainingModel(element), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationContextType(), typeId);
    }

    public static TriggerTypeType getTriggerType(IModelElement element, String typeId) {
        return (TriggerTypeType)ModelUtils.findIdentifiableElement(ModelUtils.findContainingModel(element), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_TriggerType(), typeId);
    }

    private ModelUtils() {
    }

    public static IDataInitializer getInitializer(DataTypeType type) {
        SpiExtensionRegistry registry;
        Map<String, IConfigurationElement> extensions;
        IConfigurationElement config;
        if (type != null && (config = (extensions = (registry = SpiExtensionRegistry.instance()).getExtensions("dataTypes")).get(type.getId())) != null) {
            try {
                return (IDataInitializer)config.createExecutableExtension("initializerClass");
            }
            catch (CoreException coreException) {
            }
            catch (ClassCastException classCastException) {}
        }
        return null;
    }

    public static DirectionType getDualDirection(DirectionType direction) {
        DirectionType result = DirectionType.IN_LITERAL.equals((Object)direction) ? DirectionType.OUT_LITERAL : (DirectionType.OUT_LITERAL.equals((Object)direction) ? DirectionType.IN_LITERAL : direction);
        return result;
    }

    public static List<IResourceResolver> getResourceResolvers() {
        ArrayList resolvers = CollectionUtils.newArrayList();
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        Map<String, IConfigurationElement> extensions = registry.getExtensions("org.eclipse.stardust.model.xpdl", "resourceResolver");
        for (Map.Entry<String, IConfigurationElement> extension : extensions.entrySet()) {
            try {
                IResourceResolver rawResolver = (IResourceResolver)extension.getValue().createExecutableExtension("class");
                if (!(rawResolver instanceof IResourceResolver)) continue;
                resolvers.add(rawResolver);
            }
            catch (CoreException coreException) {}
        }
        return resolvers;
    }

    public static IIdentifiableModelElement getIdentifiableModelProxy(EObject model, Class<?> theClass) {
        return (IIdentifiableModelElement)Proxy.newProxyInstance(IModelElement.class.getClassLoader(), new Class[]{IIdentifiableModelElement.class, theClass}, (InvocationHandler)new EObjectInvocationHandler(model));
    }

    private static Object doInvoke(Object proxy, EObject model, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(EObject.class)) {
            if ("eGet".equals(method.getName()) || "eSet".equals(method.getName()) || "eIsSet".equals(method.getName()) || "eUnset".equals(method.getName())) {
                if (args != null && CarnotWorkflowModelPackage.eINSTANCE.getIModelElement_ElementOid().equals(args[0])) {
                    Object[] modifiedArgs = (Object[])args.clone();
                    modifiedArgs[0] = CarnotWorkflowModelPackage.eINSTANCE.getModelType_Oid();
                    return method.invoke((Object)model, modifiedArgs);
                }
                return method.invoke((Object)model, args);
            }
            return method.invoke((Object)model, args);
        }
        if (method.getDeclaringClass().equals(IModelElement.class)) {
            if (method.getName().equals("getElementOid") && model instanceof ModelType) {
                return new Long(((ModelType)model).getModelOID());
            }
            if (method.getName().equals("setElementOid") && model instanceof ModelType) {
                ((ModelType)model).setModelOID(((Long)args[0]).intValue());
            } else if (method.getName().equals("unsetElementOid") && model instanceof ModelType) {
                ((ModelType)model).unsetModelOID();
            } else if (method.getName().equals("isSetElementOid") && model instanceof ModelType) {
                return ((ModelType)model).isSetModelOID() ? Boolean.TRUE : Boolean.FALSE;
            }
            return null;
        }
        if (method.getDeclaringClass().equals(IIdentifiableModelElement.class)) {
            if (method.getName().equals("getDescription") && model instanceof ModelType) {
                return ((ModelType)model).getDescription();
            }
            if (method.getName().equals("setDescription") && model instanceof ModelType) {
                ((ModelType)model).setDescription((DescriptionType)args[0]);
            }
            return null;
        }
        if (method.getDeclaringClass().equals(Object.class) && method.getName().equals("equals")) {
            return model.equals(args[0]) || proxy == args[0];
        }
        return method.invoke((Object)model, args);
    }

    public static String computeId(String name) {
        if (name == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if ((name = name.trim()).equals("")) {
            return "";
        }
        int i = 0;
        while (i < name.length()) {
            char charAt = name.charAt(i);
            if (i == 0) {
                if (!Character.isJavaIdentifierStart(charAt)) {
                    charAt = '_';
                }
            } else if (!Character.isJavaIdentifierPart(charAt) && !Character.isWhitespace(charAt)) {
                charAt = '_';
            }
            if (!Character.isWhitespace(charAt)) {
                sb.append(charAt);
            }
            ++i;
        }
        return sb.toString();
    }

    public static void resolve(ModelType model, IExtensibleElement extensible) {
        List<IConfigurationElement> configs;
        TypeDeclarationsType declarations;
        if (extensible == model && (declarations = model.getTypeDeclarations()) != null) {
            EList<TypeDeclarationType> types = declarations.getTypeDeclaration();
            for (Object decl : types) {
                XSDSchema schema;
                XpdlTypeType xpdlType = decl.getDataType();
                if (!(xpdlType instanceof SchemaTypeType) || (schema = ((SchemaTypeType)xpdlType).getSchema()) == null) continue;
                schema.setSchemaLocation("urn:internal:" + decl.getId());
            }
        }
        if ((configs = SpiExtensionRegistry.getConfiguration(extensible, "elementReference")) != null) {
            for (IConfigurationElement config : configs) {
                IConfigurationElement[] refs;
                IConfigurationElement[] iConfigurationElementArray = refs = config.getChildren("attribute");
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ref = iConfigurationElementArray[n2];
                    AttributeType attribute = AttributeUtil.getAttribute(extensible, ref.getAttribute("attributeName"));
                    if (attribute != null) {
                        String scopeList = ref.getAttribute("scope");
                        ModelUtils.setReference(attribute, model, scopeList);
                    }
                    ++n2;
                }
            }
        }
        IAttributeCategory category = AttributeUtil.createAttributeCategory(extensible, "authorization");
        for (AttributeType attribute : category.getAttributes()) {
            ModelUtils.setReference(attribute, model, "role+organization");
        }
        for (Object item : extensible.eContents()) {
            if (!(item instanceof IExtensibleElement)) continue;
            ModelUtils.resolve(model, (IExtensibleElement)item);
        }
    }

    public static void setReference(AttributeType attribute, ModelType model, String scopeList) {
        String id = attribute.getValue();
        int ix = id.indexOf(58);
        if (ix > 0) {
            ModelType otherModel;
            ExternalPackage pkg;
            QName qname = QName.valueOf(id.substring(ix + 1));
            ExternalPackages packages = model.getExternalPackages();
            if (packages != null && (pkg = packages.getExternalPackage(qname.getNamespaceURI())) != null && (otherModel = ModelUtils.getExternalModel(pkg)) != null) {
                model = otherModel;
                scopeList = id.substring(0, ix);
                if ("typeDeclaration".equals(scopeList)) {
                    scopeList = "struct";
                }
                id = qname.getLocalPart();
            }
        }
        StringTokenizer st = new StringTokenizer(scopeList, "+");
        while (st.hasMoreTokens()) {
            String scope = st.nextToken();
            if ("struct".equals(scope)) {
                TypeDeclarationType decl;
                TypeDeclarationsType declarations = model.getTypeDeclarations();
                if (declarations == null || (decl = ModelUtils.findElementById(declarations.getTypeDeclaration(), id)) == null) continue;
                AttributeUtil.setReference(attribute, decl);
                continue;
            }
            EStructuralFeature feature = model.eClass().getEStructuralFeature(scope);
            IIdentifiableElement element = ModelUtils.findIdentifiableElement(model, feature, id);
            if (element == null) continue;
            AttributeUtil.setReference(attribute, element);
            break;
        }
    }

    public static boolean isValidId(String id) {
        if (id == null || id.equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < id.length()) {
            if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static ModelType parseModelType(String modelString) {
        String modelXmlEncoding = ModelUtils.getXmlEncoding(modelString);
        CarnotWorkflowModelResourceImpl resource = new CarnotWorkflowModelResourceImpl(URI.createURI((String)"http://only/a/dummy/URI"));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResources().add((Object)resource);
        Map options = CollectionUtils.newMap();
        options.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        try {
            resource.load(new ByteArrayInputStream(modelString.getBytes(modelXmlEncoding)), options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Object o : resource.getContents()) {
            if (!(o instanceof DocumentRoot)) continue;
            ModelType model = ((DocumentRoot)o).getModel();
            ModelUtils.resolve(model, model);
            return model;
        }
        throw new RuntimeException(Model_Messages.EXC_COULD_NOT_LOAD_MODEL_DOC_ROOT_NOT_FOUND);
    }

    private static String getXmlEncoding(String text) {
        String pattern = "encoding=\"";
        int offset = text.indexOf(pattern) + pattern.length();
        int pos = text.indexOf("\"", offset);
        return text.substring(offset, pos);
    }

    public static EObject getEObject(IAdaptable adaptable) {
        if (adaptable == null) {
            return null;
        }
        IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)adaptable.getAdapter(IModelElementNodeSymbol.class);
        if (symbol != null) {
            IIdentifiableModelElement modelElement = symbol.getModelElement();
            return modelElement == null ? symbol : modelElement;
        }
        IModelElement modelElement = (IModelElement)adaptable.getAdapter(IModelElement.class);
        return modelElement == null ? (EObject)adaptable.getAdapter(EObject.class) : modelElement;
    }

    public static IModelElement findElementByOid(List<?> list, long elementOid) {
        for (Object object : list) {
            if (!(object instanceof IModelElement) || ((IModelElement)object).getElementOid() != elementOid) continue;
            return (IModelElement)object;
        }
        return null;
    }

    public static EObject findElementByFeature(List<?> list, Object prototype, String featureName) {
        if (!(prototype instanceof EObject)) {
            return null;
        }
        EClass class1 = ((EObject)prototype).eClass();
        EStructuralFeature feature = class1.getEStructuralFeature(featureName);
        if (feature == null) {
            return null;
        }
        Object value1 = ((EObject)prototype).eGet(feature);
        for (Object object : list) {
            Object value2;
            EClass class2;
            if (!(object instanceof EObject) || !(class2 = ((EObject)object).eClass()).equals(class1) || !CompareHelper.areEqual((Object)value1, (Object)(value2 = ((EObject)object).eGet(feature)))) continue;
            return (EObject)object;
        }
        return null;
    }

    public static IModelParticipant findParticipant(String participantId, List<? extends IModelParticipant> ... participants) {
        List<? extends IModelParticipant>[] listArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            List<? extends IModelParticipant> list = listArray[n2];
            for (IModelParticipant iModelParticipant : list) {
                if (!iModelParticipant.getId().equals(participantId)) continue;
                return iModelParticipant;
            }
            ++n2;
        }
        return null;
    }

    public static List<FormalParameterType> findAllFormalParameters(ModelType model) {
        ArrayList<FormalParameterType> result = new ArrayList<FormalParameterType>();
        EList<ProcessDefinitionType> processes = model.getProcessDefinition();
        for (ProcessDefinitionType process : processes) {
            if (process.getFormalParameters().getFormalParameter() == null) continue;
            result.addAll((Collection<FormalParameterType>)process.getFormalParameters().getFormalParameter());
        }
        return result;
    }

    public static List<String> getURIsForExternalPackages(ModelType model) {
        ArrayList<String> result = new ArrayList<String>();
        ExternalPackages externalPackages = model.getExternalPackages();
        if (externalPackages != null) {
            for (ExternalPackage externalPackage : externalPackages.getExternalPackage()) {
                ExtendedAttributeType attribute = ExtendedAttributeUtil.getAttribute(externalPackage.getExtendedAttributes(), "carnot:connection:uri");
                if (attribute == null || attribute.getValue() == null) continue;
                result.add(attribute.getValue());
            }
        }
        return result;
    }

    public static boolean referenceToAnotherVersionExists(ModelType model, String uri) {
        ModelType refModel = ModelUtils.getReferencedModelByURI(model, uri);
        List<String> allReferencedURIs = ModelUtils.getURIsForExternalPackages(model);
        for (String aUri : allReferencedURIs) {
            ModelType aModel;
            EObject aObject;
            if (uri.equalsIgnoreCase(aUri) || (aObject = model.getConnectionManager().find(aUri)) == null || !(aModel = (ModelType)Reflect.getFieldValue((Object)aObject, (String)"eObject")).getId().equalsIgnoreCase(refModel.getId())) continue;
            return true;
        }
        return false;
    }

    public static ModelType getReferencedModelByURI(ModelType model, String uri) {
        Object refObject;
        EObject o = model.getConnectionManager().find(uri);
        ModelType refModel = null;
        if (o != null && (refObject = Reflect.getFieldValue((Object)o, (String)"eObject")) != null && refObject instanceof ModelType) {
            refModel = (ModelType)refObject;
        }
        return refModel;
    }

    public static Map<String, TypeType> getTypeMapping() {
        Map typeMapping = CollectionUtils.newMap();
        typeMapping.put(Type.String.getId(), TypeType.STRING);
        typeMapping.put(Type.Integer.getId(), TypeType.INTEGER);
        typeMapping.put(Type.Boolean.getId(), TypeType.BOOLEAN);
        typeMapping.put(Type.Calendar.getId(), TypeType.DATETIME);
        return typeMapping;
    }

    public static org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType createDataType(DataType data) {
        Map<String, TypeType> typeMapping = ModelUtils.getTypeMapping();
        org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType dataType = xpdlFactory.createDataTypeType();
        String typeId = data.getType().getId();
        if ("primitive".equals(typeId)) {
            BasicTypeType basicType = xpdlFactory.createBasicTypeType();
            String primitiveType = AttributeUtil.getAttributeValue(data, "carnot:engine:type");
            TypeType tt = typeMapping.get(primitiveType);
            if (tt != null) {
                basicType.setType(tt);
            }
            dataType.setBasicType(basicType);
        } else if ("struct".equals(typeId)) {
            DeclaredTypeType declaredType = xpdlFactory.createDeclaredTypeType();
            declaredType.setId(AttributeUtil.getAttributeValue(data, "carnot:engine:dataType"));
            dataType.setDeclaredType(declaredType);
        }
        return dataType;
    }

    public static FormalParameterType cloneFormalParameterType(FormalParameterType referencedParameterType, DataType mappedData) {
        FormalParameterType parameterType = XpdlFactory.eINSTANCE.createFormalParameterType();
        if (mappedData != null) {
            parameterType.setDataType(ModelUtils.createDataType(mappedData));
        } else {
            parameterType.setDataType((org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType)EcoreUtil.copy((EObject)referencedParameterType.getDataType()));
        }
        parameterType.setDescription(referencedParameterType.getDescription());
        parameterType.setMode(referencedParameterType.getMode());
        parameterType.setId(referencedParameterType.getId());
        parameterType.setName(referencedParameterType.getName());
        return parameterType;
    }

    public static boolean haveDifferentTypes(FormalParameterType type1, FormalParameterType type2) {
        org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType dataType1 = type1.getDataType();
        org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType dataType2 = type2.getDataType();
        if (dataType1 != null && dataType2 != null) {
            BasicTypeType basicType1 = dataType1.getBasicType();
            BasicTypeType basicType2 = dataType2.getBasicType();
            DeclaredTypeType declaredType1 = dataType1.getDeclaredType();
            DeclaredTypeType declaredType2 = dataType2.getDeclaredType();
            if (declaredType1 != null && declaredType2 != null) {
                return !declaredType1.getId().equals(declaredType2.getId());
            }
            if (basicType1 != null && declaredType2 != null) {
                return true;
            }
            if (basicType2 != null && declaredType1 != null) {
                return true;
            }
            if (basicType1 != null && basicType2 != null && basicType1.getType().getName().equals(basicType2.getType().getName())) {
                return false;
            }
        }
        return true;
    }

    public static <T extends Predicate<ModelType>> void forEachReferencedModel(ModelType model, T predicate) {
        ExternalPackages packages = model.getExternalPackages();
        if (packages != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                ModelType externalModel = ModelUtils.getExternalModel(pkg);
                if (externalModel != null && !predicate.accept((Object)externalModel)) break;
            }
        }
    }

    public static ModelType getExternalModel(ExternalPackage pack) {
        ModelType model;
        IConnectionManager manager;
        String uri = ExtendedAttributeUtil.getAttributeValue(pack, "carnot:connection:uri");
        if (!StringUtils.isEmpty((String)uri) && (manager = (model = ModelUtils.findContainingModel(pack)).getConnectionManager()) != null) {
            Object externalModel = manager.find(uri);
            if (externalModel instanceof IObjectReference) {
                externalModel = ((IObjectReference)externalModel).getEObject();
            }
            if (externalModel instanceof ModelType) {
                return (ModelType)externalModel;
            }
        }
        return null;
    }

    public static boolean hasCircularDependency(String referencingModelID, ModelType referencedModel) {
        if (referencingModelID.equalsIgnoreCase(referencedModel.getId())) {
            return true;
        }
        ExternalPackages externalPackages = referencedModel.getExternalPackages();
        if (externalPackages != null) {
            for (ExternalPackage externalPackage : externalPackages.getExternalPackage()) {
                if (externalPackage.getHref().equals(referencingModelID)) {
                    return true;
                }
                ModelType m = referencedModel.getConnectionManager().find(externalPackage);
                if (!ModelUtils.hasCircularDependency(referencingModelID, m)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean externalPackageExists(ModelType referingModel, ModelType referencedModel) {
        ExternalPackages externalPackages = referingModel.getExternalPackages();
        if (externalPackages != null) {
            for (ExternalPackage externalPackage : externalPackages.getExternalPackage()) {
                if (!externalPackage.getHref().equals(referencedModel.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public static List<IModelElement> findPackageReferingModelElements(ModelType referingModel, ExternalPackage externalPackage) {
        List result = CollectionUtils.newList();
        for (ProcessDefinitionType process : referingModel.getProcessDefinition()) {
            ExternalPackage packageRef;
            IdRef externalRef = process.getExternalRef();
            if (externalRef != null && (packageRef = externalRef.getPackageRef()) != null && packageRef.equals(externalPackage)) {
                result.add(process);
            }
            for (ActivityType activity : process.getActivity()) {
                ExternalPackage packageRef2;
                externalRef = activity.getExternalRef();
                if (externalRef == null || (packageRef2 = externalRef.getPackageRef()) == null || !packageRef2.equals(externalPackage)) continue;
                result.add(activity);
            }
        }
        return result;
    }

    public static String getActivityImplementationTypeText(ActivityImplementationType implementation) {
        switch (implementation) {
            case MANUAL_LITERAL: {
                return Model_Messages.MANUAL_ACTIVITY;
            }
            case ROUTE_LITERAL: {
                return Model_Messages.ROUTE_ACTIVITY;
            }
            case APPLICATION_LITERAL: {
                return Model_Messages.APPLICATION_ACTIVITY;
            }
            case SUBPROCESS_LITERAL: {
                return Model_Messages.SUBPROCESS_ACTIVITY;
            }
        }
        return "";
    }

    public static String getSubprocessModeTypeText(SubProcessModeType modeType) {
        switch (modeType) {
            case SYNC_SHARED_LITERAL: {
                return Model_Messages.SYNC_SHARED;
            }
            case SYNC_SEPARATE_LITERAL: {
                return Model_Messages.SYNC_SEPARATE;
            }
            case ASYNC_SEPARATE_LITERAL: {
                return Model_Messages.ASYNC_SEPARATE;
            }
        }
        return "";
    }

    public static String getFlowTypeText(String literal) {
        if (literal.equals("AND")) {
            return Model_Messages.JOIN_SPLIT_LOOP_AND;
        }
        if (literal.equals("XOR")) {
            return Model_Messages.JOIN_SPLIT_LOOP_XOR;
        }
        if (literal.equals("None")) {
            return Model_Messages.JOIN_SPLIT_LOOP_NONE;
        }
        if (literal.equals("No Loop")) {
            return Model_Messages.JOIN_SPLIT_LOOP_NOLOOP;
        }
        if (literal.equals("Standard")) {
            return Model_Messages.JOIN_SPLIT_LOOP_STANDARD;
        }
        if (literal.equals("MultiInstance")) {
            return Model_Messages.JOIN_SPLIT_LOOP_MULTI_INSTANCE;
        }
        if (literal.equals("After")) {
            return Model_Messages.JOIN_SPLIT_LOOP_REPEAT;
        }
        if (literal.equals("Before")) {
            return Model_Messages.JOIN_SPLIT_LOOP_WHILE;
        }
        if (literal.equals("Repeat")) {
            return Model_Messages.JOIN_SPLIT_LOOP_REPEAT;
        }
        if (literal.equals("While")) {
            return Model_Messages.JOIN_SPLIT_LOOP_WHILE;
        }
        if (literal.equals("Unknown")) {
            return Model_Messages.JOIN_SPLIT_LOOP_UNKNOWN;
        }
        return literal;
    }

    public static List<TypeDeclarationType> getAllTypeDeclarations(ModelType modelType) {
        List dataTypes = CollectionUtils.newList();
        ModelUtils.addTypeDeclarations(dataTypes, modelType);
        ExternalPackages packages = modelType.getExternalPackages();
        if (packages != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                ModelType externalModel = ModelUtils.getExternalModel(pkg);
                if (externalModel == null) continue;
                ModelUtils.addTypeDeclarations(dataTypes, externalModel);
            }
        }
        return dataTypes;
    }

    private static void addTypeDeclarations(List<TypeDeclarationType> dataTypes, ModelType modelType) {
        TypeDeclarationsType typeDeclarations = modelType.getTypeDeclarations();
        if (typeDeclarations != null) {
            dataTypes.addAll((Collection<TypeDeclarationType>)typeDeclarations.getTypeDeclaration());
        }
    }

    public static ArrayList<String> getPersistenceOptions(ProcessDefinitionType process) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(AuditTrailPersistence.IMMEDIATE.name());
        for (ActivityType activity : process.getActivity()) {
            String directionType;
            if (activity.getApplication() == null) continue;
            ApplicationType application = activity.getApplication();
            if (application.isInteractive()) {
                return list;
            }
            if (!application.getType().getId().equals("jms") || (directionType = AttributeUtil.getAttributeValue(application, "carnot:engine:type")) == null || directionType.equalsIgnoreCase("out")) continue;
            return list;
        }
        list.add(AuditTrailPersistence.TRANSIENT.name());
        list.add(AuditTrailPersistence.DEFERRED.name());
        return list;
    }

    public static String getPersistenceOptionsText(String value) {
        if (value.equals(AuditTrailPersistence.IMMEDIATE.name())) {
            return Model_Messages.AUDITTRAIL_PERSISTENCE_IMMEDIATE;
        }
        if (value.equals(AuditTrailPersistence.DEFERRED.name())) {
            return Model_Messages.AUDITTRAIL_PERSISTENCE_DEFERRED;
        }
        if (value.equals(AuditTrailPersistence.TRANSIENT.name())) {
            return Model_Messages.AUDITTRAIL_PERSISTENCE_TRANSIENT;
        }
        return null;
    }

    public static boolean isReadOnly(EObject element) {
        AttributeType attribute;
        return element != null && element instanceof ModelType && (attribute = AttributeUtil.getAttribute((ModelType)element, "stardust:security:hash")) != null && attribute.getValue() != null && attribute.getValue().length() > 0;
    }

    public static ModelType getModelByProxyURI(ModelType model, URI proxyUri) {
        EObject connectionObject;
        ModelType referencedModel = null;
        if (model != null && model.getConnectionManager() != null && (connectionObject = model.getConnectionManager().find(String.valueOf(proxyUri.scheme()) + "://" + proxyUri.authority() + "/")) != null) {
            referencedModel = (ModelType)Reflect.getFieldValue((Object)connectionObject, (String)"eObject");
        }
        return referencedModel;
    }

    public static ModelType getExternalModel(ModelType model, String modelID) {
        ExternalPackages packages = model.getExternalPackages();
        if (packages != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                ModelType otherModel = ModelUtils.getExternalModel(pkg);
                if (!otherModel.getId().equals(modelID)) continue;
                return otherModel;
            }
        }
        return null;
    }

    public static final class EObjectInvocationHandler
    implements InvocationHandler {
        private final EObject model;

        public EObjectInvocationHandler(EObject model) {
            this.model = model;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return ModelUtils.doInvoke(proxy, this.model, method, args);
        }

        public EObject getModel() {
            return this.model;
        }
    }
}

