/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.authorization;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.authorization.Permission;

public class AuthorizationUtils {
    public static final String ACTIVITY_SCOPE = "activity";
    public static final String DATA_SCOPE = "data";
    public static final String PROCESS_DEFINITION_SCOPE = "processDefinition";
    public static final String MODEL_SCOPE = "model";

    public static List<Permission> getPermissions(IExtensibleElement element) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        String scope = AuthorizationUtils.getScope(element);
        if (element != null) {
            List extensions = SpiExtensionRegistry.instance().getExtensionList("org.eclipse.stardust.modeling.authorization", "modelElementPermission");
            for (IConfigurationElement config : extensions) {
                if (!config.getAttribute("scope").equals(scope)) continue;
                Permission permission = new Permission(config, element);
                if (!AuthorizationUtils.isInteractiveActivity(element) && permission.isDefaultOwner()) {
                    ModelType model = ModelUtils.findContainingModel((EObject)element);
                    RoleType admin = (RoleType)ModelUtils.findIdentifiableElement((List)model.getRole(), (String)"Administrator");
                    permission.setDefault((IModelParticipant)admin);
                }
                permissions.add(permission);
            }
        }
        return permissions;
    }

    public static String getScope(IExtensibleElement element) {
        if (element instanceof ModelType) {
            return MODEL_SCOPE;
        }
        if (element instanceof ProcessDefinitionType) {
            return PROCESS_DEFINITION_SCOPE;
        }
        if (element instanceof DataType) {
            return DATA_SCOPE;
        }
        if (element instanceof ActivityType) {
            return ACTIVITY_SCOPE;
        }
        return null;
    }

    public static boolean isInteractiveActivity(IExtensibleElement element) {
        return element instanceof ActivityType && ActivityUtil.isInteractive((ActivityType)((ActivityType)element));
    }
}

