/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.authorization.propertypages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ScopeUtils;
import org.eclipse.stardust.modeling.authorization.AuthorizationUtils;
import org.eclipse.stardust.modeling.authorization.Authorization_Messages;
import org.eclipse.stardust.modeling.authorization.Permission;
import org.eclipse.stardust.modeling.authorization.propertypages.ParticipantLabelProvider;
import org.eclipse.stardust.modeling.authorization.propertypages.PermissionLabelProvider;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class AuthorizationPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final String[] PERMISSION_COLUMN_NAME = new String[]{Authorization_Messages.PERMISSION_COLUMN_LABEL};
    private static final String[] PARTICIPANT_COLUMN_NAME = new String[]{Authorization_Messages.PARTICIPANT_COLUMN_LABEL};
    private TableViewer permissionViewer;
    private TableViewer participantViewer;
    private ParticipantLabelProvider participantLabelProvider;
    private List<Object> participants;
    private ArrayList<Permission> permissions;
    private Permission permission;

    protected Control createContents(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        Table permissionTable = FormBuilder.createTable((Composite)composite, (int)67588, (String[])PERMISSION_COLUMN_NAME, (int[])new int[]{100}, (int)1);
        this.permissionViewer = new TableViewer(permissionTable);
        this.permissionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.permissionViewer.setLabelProvider((IBaseLabelProvider)new PermissionLabelProvider());
        this.permissionViewer.setInput(this.getPermissions());
        this.permissionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AuthorizationPropertyPage.this.updateParticipantsTable();
                AuthorizationPropertyPage.this.validate();
            }
        });
        Table participantTable = FormBuilder.createTable((Composite)composite, (int)67620, (String[])PARTICIPANT_COLUMN_NAME, (int[])new int[]{100}, (int)1);
        this.participantViewer = new TableViewer(participantTable);
        this.participantViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.participantLabelProvider = new ParticipantLabelProvider(participantTable.getFont());
        this.participantViewer.setLabelProvider((IBaseLabelProvider)this.participantLabelProvider);
        this.participantViewer.setInput((Object)Collections.EMPTY_LIST);
        participantTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    TableItem item = (TableItem)e.item;
                    Object participant = item.getData();
                    if ("All" == participant) {
                        if (item.getChecked()) {
                            AuthorizationPropertyPage.this.permission.setALL();
                        } else {
                            AuthorizationPropertyPage.this.permission.unsetALL();
                        }
                    } else if ("Owner" == participant) {
                        if (item.getChecked()) {
                            AuthorizationPropertyPage.this.permission.setOWNER();
                        } else {
                            AuthorizationPropertyPage.this.permission.unsetOWNER();
                        }
                    } else if (participant instanceof IModelParticipant) {
                        if (item.getChecked()) {
                            AuthorizationPropertyPage.this.permission.addParticipant((IModelParticipant)participant);
                        } else {
                            AuthorizationPropertyPage.this.permission.removeParticipant((IModelParticipant)participant);
                        }
                    }
                    AuthorizationPropertyPage.this.updateCheckStatus();
                    AuthorizationPropertyPage.this.validate();
                }
            }
        });
        this.validate();
        return composite;
    }

    private void validate() {
        boolean isValid = true;
        IModelElement element = this.getModel();
        if (element instanceof ModelType) {
            HashSet scoped = ScopeUtils.findScopedParticipants((ModelType)((ModelType)element));
            for (IModelParticipant participant : scoped) {
                if (this.permission == null || !this.permission.contains(participant)) continue;
                isValid = false;
                break;
            }
        }
        if (isValid) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setValid(false);
            this.setErrorMessage(Authorization_Messages.ERR_MSG_SCOPED_PARTICIPANTS_ARE_NOT_ALLOWED_FOR_MODEL_LEVEL_GRANTS);
        }
    }

    private List<Object> getParticipants() {
        if (this.participants == null) {
            Comparator<IModelParticipant> comparator = new Comparator<IModelParticipant>(){

                @Override
                public int compare(IModelParticipant first, IModelParticipant second) {
                    return this.toString(first).compareTo(this.toString(second));
                }

                private String toString(IModelParticipant o) {
                    String label = o.getName();
                    if (label == null) {
                        label = o.getId();
                    }
                    return label == null ? "" : label;
                }
            };
            this.participants = new ArrayList<Object>();
            this.participants.add("All");
            if (AuthorizationUtils.isInteractiveActivity((IExtensibleElement)this.getModel())) {
                this.participants.add("Owner");
            }
            IModelElement element = this.getModel();
            ModelType model = ModelUtils.findContainingModel((EObject)element);
            ArrayList roles = new ArrayList();
            roles.addAll(model.getRole());
            Collections.sort(roles, comparator);
            this.participants.addAll(roles);
            ArrayList organizations = new ArrayList();
            organizations.addAll(model.getOrganization());
            Collections.sort(organizations, comparator);
            this.participants.addAll(organizations);
        }
        return this.participants;
    }

    private List<Permission> getPermissions() {
        if (this.permissions == null) {
            this.permissions = (ArrayList)AuthorizationUtils.getPermissions((IExtensibleElement)this.getModel());
        }
        return this.permissions;
    }

    private IModelElement getModel() {
        IModelElement element = null;
        IAdaptable adaptable = this.getElement();
        if (adaptable != null && (element = (IModelElement)adaptable.getAdapter(IModelElement.class)) instanceof IModelElementNodeSymbol) {
            element = ((IModelElementNodeSymbol)element).getModelElement();
        }
        return element;
    }

    public boolean performOk() {
        IExtensibleElement element = (IExtensibleElement)this.getModel();
        if (element == null) {
            return true;
        }
        EList attributes = element.getAttribute();
        int i = attributes.size() - 1;
        while (i >= 0) {
            AttributeType attribute = (AttributeType)attributes.get(i);
            if (attribute.getName() != null && attribute.getName().startsWith("authorization:")) {
                attributes.remove(i);
            }
            --i;
        }
        for (Permission permission : this.getPermissions()) {
            permission.save(element);
        }
        return true;
    }

    protected void performDefaults() {
        for (Permission permission : this.permissions) {
            permission.restoreDefaults();
        }
        this.updateParticipantsTable();
        super.performDefaults();
    }

    private void updateParticipantsTable() {
        IStructuredSelection selection = (IStructuredSelection)this.permissionViewer.getSelection();
        this.permission = (Permission)selection.getFirstElement();
        if (this.permission == null) {
            this.participantViewer.setInput((Object)Collections.EMPTY_LIST);
        } else {
            this.participantLabelProvider.setPermission(this.permission);
            this.participantViewer.setInput(this.getParticipants());
            this.updateCheckStatus();
        }
    }

    private void updateCheckStatus() {
        List<Object> participants = this.getParticipants();
        TableItem[] items = this.participantViewer.getTable().getItems();
        items[0].setChecked(this.permission.isALL());
        boolean isInteractiveActivity = AuthorizationUtils.isInteractiveActivity((IExtensibleElement)this.getModel());
        if (isInteractiveActivity) {
            items[1].setChecked(this.permission.isOWNER());
        }
        int i = isInteractiveActivity ? 2 : 1;
        while (i < participants.size()) {
            IModelParticipant participant = (IModelParticipant)participants.get(i);
            items[i].setChecked(this.permission.contains(participant));
            ++i;
        }
    }
}

