/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.authorization.propertypages;

import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.modeling.authorization.AuthorizationAspectPlugin;
import org.eclipse.stardust.modeling.authorization.Authorization_Messages;
import org.eclipse.stardust.modeling.authorization.Permission;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class ParticipantLabelProvider
extends LabelProvider
implements IFontProvider {
    private Font defaultFont;
    private Font otherFont;
    private Permission permission;

    public ParticipantLabelProvider(Font defaultFont) {
        this.defaultFont = defaultFont;
        if (defaultFont != null) {
            FontData fontData = defaultFont.getFontData()[0];
            fontData.setStyle(fontData.getStyle() ^ 2);
            this.otherFont = new Font(defaultFont.getDevice(), fontData);
        }
    }

    public String getText(Object element) {
        boolean isDefault = false;
        String label = null;
        if (element == "All") {
            label = Authorization_Messages.LBL_ALL;
            isDefault = this.permission.isDefaultAll();
        } else if (element == "Owner") {
            label = Authorization_Messages.LBL_OWNER;
            isDefault = this.permission.isDefaultOwner();
        } else if (element instanceof IModelParticipant) {
            IModelParticipant participant = (IModelParticipant)element;
            label = participant.getName();
            if (label == null) {
                label = participant.getId();
            }
            isDefault = this.permission.isDefault(participant);
        } else if (element != null) {
            label = element.toString();
        }
        if (label != null && isDefault) {
            label = String.valueOf(label) + Authorization_Messages.LBL_DEFAULT;
        }
        return label == null ? "" : label;
    }

    public Image getImage(Object element) {
        if (element == "All" || element == "Owner" || element instanceof RoleType) {
            return AuthorizationAspectPlugin.getDefault().getImage("icons/role.gif");
        }
        if (element instanceof OrganizationType) {
            return AuthorizationAspectPlugin.getDefault().getImage("icons/organization.gif");
        }
        return null;
    }

    public Font getFont(Object element) {
        if ((element == "All" || element == "Owner") && this.otherFont != null) {
            return this.otherFont;
        }
        return this.defaultFont;
    }

    public void dispose() {
        this.otherFont.dispose();
        this.defaultFont = null;
        this.otherFont = null;
        super.dispose();
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }
}

