/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.databinding;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EFeatureAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EObjectAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.StructuredViewerAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtButtonAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtComboAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtLabelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtListAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtTextAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtWidgetAdapter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class BindingManager {
    private final Mediator mediator = new Mediator();
    private final Map<Object, Map<IModelAdapter, IWidgetAdapter>> bindings = new IdentityHashMap<Object, Map<IModelAdapter, IWidgetAdapter>>();
    private final Map<IWidgetAdapter, IModelAdapter> widget2ModelIndex = new IdentityHashMap<IWidgetAdapter, IModelAdapter>();

    public void bind(EObject model, EStructuralFeature feature, Label label) {
        this.bind(model, feature, BindingManager.createWidgetAdapter(label));
    }

    public void bind(EObject model, EStructuralFeature feature, Text text) {
        this.bind(model, feature, BindingManager.createWidgetAdapter(text));
    }

    public void bind(EObject model, EStructuralFeature feature, EFeatureAdapter ftrAdapter, Text text) {
        this.bind(model, feature, ftrAdapter, BindingManager.createWidgetAdapter(text));
    }

    public void bind(EObject model, EStructuralFeature feature, Button button) {
        this.bind(model, feature, BindingManager.createWidgetAdapter(button));
    }

    public void bind(EObject model, EStructuralFeature feature, Combo combo) {
        this.bind(model, feature, BindingManager.createWidgetAdapter(combo));
    }

    public void bind(EObject model, EStructuralFeature feature, List list) {
        this.bind(model, feature, BindingManager.createWidgetAdapter(list));
    }

    public void bind(EObject model, EStructuralFeature feature, StructuredViewer viewer) {
        this.bind(model, feature, BindingManager.createWidgetAdapter(viewer));
    }

    public void bind(EObject model, IWidgetAdapter widgetAdapter) {
        this.bind(model, null, widgetAdapter);
    }

    public void bind(EObject model, EStructuralFeature eFtr, IWidgetAdapter widgetAdapter) {
        this.bind(BindingManager.createModelAdapter(model, eFtr), widgetAdapter);
    }

    public void bind(EObject model, EStructuralFeature eFtr, EFeatureAdapter ftrAdapter, StructuredViewer viewer) {
        this.bind(BindingManager.createModelAdapter(model, eFtr, ftrAdapter), BindingManager.createWidgetAdapter(viewer));
    }

    public void bind(EObject model, EStructuralFeature eFtr, EFeatureAdapter ftrAdapter, IWidgetAdapter widgetAdapter) {
        this.bind(BindingManager.createModelAdapter(model, eFtr, ftrAdapter), widgetAdapter);
    }

    public void bind(IModelAdapter modelAdapter, IWidgetAdapter widgetAdapter) {
        Map<IModelAdapter, IWidgetAdapter> modelBindings = this.bindings.get(modelAdapter.getModel());
        if (modelBindings == null) {
            modelBindings = new HashMap<IModelAdapter, IWidgetAdapter>();
            this.bindings.put(modelAdapter.getModel(), modelBindings);
        }
        modelBindings.put(modelAdapter, widgetAdapter);
        this.widget2ModelIndex.put(widgetAdapter, modelAdapter);
        modelAdapter.bind(this.mediator);
        widgetAdapter.bind(this.mediator);
        widgetAdapter.updateVisuals(modelAdapter.getValue());
    }

    public void unbind(EObject model, Widget target) {
        Map<IModelAdapter, IWidgetAdapter> modelBindings = this.bindings.get(model);
        if (modelBindings != null) {
            for (IWidgetAdapter widgetAdapter : this.widget2ModelIndex.keySet()) {
                if (!(widgetAdapter instanceof SwtWidgetAdapter) || !((SwtWidgetAdapter)widgetAdapter).getWidget().equals(target)) continue;
                IModelAdapter modelAdapter = this.widget2ModelIndex.get(widgetAdapter);
                modelBindings.remove(modelAdapter);
                this.widget2ModelIndex.remove(widgetAdapter);
                modelAdapter.unbind();
                widgetAdapter.unbind();
                break;
            }
        }
    }

    public void unbind(EObject model, IWidgetAdapter target) {
        Map<IModelAdapter, IWidgetAdapter> modelBindings = this.bindings.get(model);
        if (modelBindings != null) {
            for (IWidgetAdapter widgetAdapter : this.widget2ModelIndex.keySet()) {
                if (!widgetAdapter.equals(target)) continue;
                IModelAdapter modelAdapter = this.widget2ModelIndex.get(widgetAdapter);
                modelBindings.remove(modelAdapter);
                this.widget2ModelIndex.remove(widgetAdapter);
                modelAdapter.unbind();
                widgetAdapter.unbind();
                break;
            }
        }
    }

    public void unbind(Object model) {
        Map<IModelAdapter, IWidgetAdapter> modelBindings = this.bindings.remove(model);
        if (modelBindings != null) {
            for (Map.Entry<IModelAdapter, IWidgetAdapter> binding : modelBindings.entrySet()) {
                binding.getKey().unbind();
                binding.getValue().unbind();
                this.widget2ModelIndex.remove(binding.getValue());
            }
            modelBindings.clear();
        }
    }

    public static IModelAdapter createModelAdapter(EObject eObj, EStructuralFeature eFtr) {
        return new EObjectAdapter(eObj, eFtr);
    }

    public static IModelAdapter createModelAdapter(EObject eObj, EStructuralFeature eFtr, EFeatureAdapter valueAdapter) {
        return new EObjectAdapter(eObj, eFtr, valueAdapter);
    }

    public static IWidgetAdapter createWidgetAdapter(Label label) {
        return new SwtLabelAdapter(label);
    }

    public static IWidgetAdapter createWidgetAdapter(Text text) {
        return new SwtTextAdapter(text);
    }

    public static IWidgetAdapter createWidgetAdapter(Button button) {
        return new SwtButtonAdapter(button);
    }

    public static IWidgetAdapter createWidgetAdapter(Combo combo) {
        return new SwtComboAdapter(combo);
    }

    public static IWidgetAdapter createWidgetAdapter(List list) {
        return new SwtListAdapter(list);
    }

    public static IWidgetAdapter createWidgetAdapter(StructuredViewer viewer) {
        return new StructuredViewerAdapter(viewer);
    }

    public void dispose() {
        while (!this.bindings.isEmpty()) {
            this.unbind(this.bindings.keySet().iterator().next());
        }
    }

    public void updateWidgets(Object model) {
        Map<IModelAdapter, IWidgetAdapter> modelBindings = this.bindings.get(model);
        if (modelBindings != null) {
            for (Map.Entry<IModelAdapter, IWidgetAdapter> binding : modelBindings.entrySet()) {
                binding.getValue().updateVisuals(binding.getKey().getValue());
            }
        }
    }

    private class Mediator
    implements IBindingMediator {
        private Mediator() {
        }

        @Override
        public void updateWidget(IModelAdapter modelAdapter, Object value) {
            IWidgetAdapter widgetAdapter;
            Map modelBindings = (Map)BindingManager.this.bindings.get(modelAdapter.getModel());
            if (modelBindings != null && (widgetAdapter = (IWidgetAdapter)modelBindings.get(modelAdapter)) != null) {
                widgetAdapter.updateVisuals(value);
            }
        }

        @Override
        public void updateModel(IWidgetAdapter binding, Object value) {
            IModelAdapter modelAdapter = (IModelAdapter)BindingManager.this.widget2ModelIndex.get(binding);
            if (modelAdapter != null) {
                modelAdapter.updateModel(value);
            }
        }
    }
}

