/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.databinding;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EFeatureAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;

public class EObjectAdapter
extends AdapterImpl
implements IModelAdapter {
    private final EObject model;
    private final EStructuralFeature feature;
    private final EFeatureAdapter modelValueAdapter;
    private IBindingMediator manager;

    public EObjectAdapter(EObject model, EStructuralFeature feature) {
        this(model, feature, EFeatureAdapter.INSTANCE);
    }

    public EObjectAdapter(EObject model, EStructuralFeature feature, EFeatureAdapter modelValueAdapter) {
        this.model = model;
        this.feature = feature;
        this.modelValueAdapter = modelValueAdapter;
    }

    public EObject getEModel() {
        return this.model;
    }

    public EStructuralFeature getEFeature() {
        return this.feature;
    }

    @Override
    public void bind(IBindingMediator manager) {
        this.manager = manager;
        if (!this.model.eAdapters().contains((Object)this)) {
            this.model.eAdapters().add((Object)this);
        }
    }

    @Override
    public void unbind() {
        this.model.eAdapters().remove((Object)this);
        this.manager = null;
    }

    @Override
    public Object getModel() {
        return this.model;
    }

    @Override
    public Object getValue() {
        Object result;
        if (this.feature == null) {
            result = this.model;
        } else {
            EObject eObject = result = this.model != null ? this.model.eGet(this.feature) : null;
        }
        if (this.modelValueAdapter != null) {
            result = this.modelValueAdapter.fromModel(this, result);
        }
        return result;
    }

    @Override
    public void updateModel(Object value) {
        Object oldValue;
        if (this.model != null && this.feature != null && !CompareHelper.areEqual((Object)(oldValue = this.getValue()), (Object)value)) {
            Object newValue = this.modelValueAdapter != null ? this.modelValueAdapter.toModel(this, value) : value;
            this.model.eSet(this.feature, newValue);
        }
    }

    public void updateVisuals(Object value) {
        if (this.manager != null) {
            this.manager.updateWidget(this, value);
        }
    }

    public void notifyChanged(Notification msg) {
        if (8 != msg.getEventType()) {
            if (this.feature == null || this.feature.equals(msg.getFeature())) {
                this.updateVisuals(this.getValue());
            } else {
                super.notifyChanged(msg);
            }
        }
    }

    public Object getFeature() {
        return this.getEFeature();
    }
}

