/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.databinding;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtWidgetAdapter;
import org.eclipse.swt.widgets.Widget;

public class StructuredViewerAdapter
extends SwtWidgetAdapter {
    private ISelectionChangedListener listener;
    private StructuredViewer viewer;

    public StructuredViewerAdapter(StructuredViewer viewer) {
        super((Widget)viewer.getControl());
        this.viewer = viewer;
    }

    @Override
    public void bind(IBindingMediator manager) {
        super.bind(manager);
        this.listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)StructuredViewerAdapter.this.viewer.getSelection();
                StructuredViewerAdapter.this.updateModel(selection == null || selection.isEmpty() ? null : selection.getFirstElement());
            }
        };
        this.viewer.addSelectionChangedListener(this.listener);
    }

    @Override
    public void unbind() {
        if (this.listener != null) {
            if (!this.getWidget().isDisposed()) {
                this.viewer.removeSelectionChangedListener(this.listener);
            }
            this.listener = null;
        }
        super.unbind();
    }

    @Override
    public void updateControl(Object value) {
        this.viewer.setSelection((ISelection)(value == null ? null : new StructuredSelection(value)));
    }
}

