/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.utils;

import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;

public class ComboBoxCellEditorViewer
extends ContentViewer {
    private ComboBoxCellEditor editor;

    public ComboBoxCellEditorViewer(ComboBoxCellEditor editor) {
        this.editor = editor;
    }

    public Control getControl() {
        return this.editor.getControl();
    }

    public ISelection getSelection() {
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        Integer value = (Integer)this.editor.getValue();
        return value == null || value == -1 ? new StructuredSelection() : new StructuredSelection(cp.getElements(this.getInput())[value]);
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.refresh();
    }

    public void refresh() {
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        ILabelProvider lp = (ILabelProvider)this.getLabelProvider();
        Object[] elements = cp.getElements(this.getInput());
        String[] items = new String[elements.length];
        int i = 0;
        while (i < items.length) {
            items[i] = lp.getText(elements[i]);
            ++i;
        }
        this.editor.setItems(items);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            this.editor.setValue((Object)new Integer(-1));
        }
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        Object value = ((IStructuredSelection)selection).getFirstElement();
        Integer index = this.find(cp.getElements(this.getInput()), value);
        this.editor.setValue((Object)index);
    }

    public Object findObject(Integer index) {
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        return index == null || index == -1 ? null : cp.getElements(this.getInput())[index];
    }

    public Integer findIndex(Object value) {
        IStructuredContentProvider cp = (IStructuredContentProvider)this.getContentProvider();
        return this.find(cp.getElements(this.getInput()), value);
    }

    private Integer find(Object[] elements, Object value) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals(value)) {
                return new Integer(i);
            }
            ++i;
        }
        return new Integer(-1);
    }
}

