/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.compatibility.el.DataTypeResolver;
import org.eclipse.stardust.engine.core.compatibility.el.JsConverter;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ScriptType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.NodeCreationFactory;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteNodeSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.IDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetSymbolContainerCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.ui.IWorkbenchPart;

public class UpdateProcessDiagramAction
extends SelectionAction {
    private static final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private WorkflowModelEditor editor;
    private Map defaultPoolsMap = new HashMap();

    public UpdateProcessDiagramAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.editor = editor;
        this.setId("org.eclipse.stardust.model.xpdl.updateProcessDiagram");
        this.setText(Diagram_Messages.LB_UpdateProcessDiagram);
    }

    public boolean isEnabled() {
        return this.calculateEnabled();
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createUpdateDiagramCmd();
        return cmd != null && cmd.canExecute();
    }

    public void run() {
        this.execute(this.createUpdateDiagramCmd());
    }

    public Command createUpdateDiagramCmd() {
        CompoundCommand command = new CompoundCommand();
        final ModelType model = this.editor.getWorkflowModel();
        if (model == null) {
            return command.unwrap();
        }
        JsConverter converter = new JsConverter(new DataTypeResolver(){

            public String resolveDataType(String dataId) {
                DataType data = (DataType)ModelUtils.findElementById((List)model.getData(), (String)dataId);
                if (data == null) {
                    return null;
                }
                DataTypeType type = data.getType();
                if (type == null) {
                    return null;
                }
                return type.getId();
            }
        });
        ScriptType script = model.getScript();
        boolean needScriptUpdate = false;
        if (script == null || StringUtils.isEmpty((String)script.getType()) || script.getType().equals("text/carnotEL")) {
            needScriptUpdate = true;
            ScriptType newScript = XpdlFactory.eINSTANCE.createScriptType();
            newScript.setType("text/ecmascript");
            SetValueCmd cmdScript = new SetValueCmd((EObject)model, (EStructuralFeature)CWM_PKG.getModelType_Script(), (Object)newScript);
            command.add((Command)cmdScript);
        }
        for (ProcessDefinitionType process : model.getProcessDefinition()) {
            for (final DiagramType diagram : process.getDiagram()) {
                if (this.checkDefaultPool(diagram)) continue;
                command.add(this.createDefaultPoolCmd(model, diagram));
            }
            if (!needScriptUpdate) continue;
            for (TransitionType transition : process.getTransition()) {
                XmlTextNode expression = transition.getExpression();
                String condition = transition.getCondition();
                if (condition == null || !condition.equals("OTHERWISE")) {
                    boolean setExpression = false;
                    String expressionValue = null;
                    if (expression == null) {
                        expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
                    } else {
                        expressionValue = ModelUtils.getCDataString((FeatureMap)expression.getMixed());
                        expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
                    }
                    if (condition != null) {
                        if (condition.equals("FALSE")) {
                            setExpression = true;
                            ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)"false", (boolean)true);
                        } else if (condition.equals("TRUE")) {
                            setExpression = true;
                            ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)"true", (boolean)true);
                        } else if (condition.equals("CONDITION") & !StringUtils.isEmpty((String)expressionValue) && !"false".equals(expressionValue) && !"true".equals(expressionValue)) {
                            setExpression = true;
                            ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)converter.convert(expressionValue), (boolean)true);
                        }
                    } else if (StringUtils.isEmpty((String)expressionValue)) {
                        setExpression = true;
                        ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)"true", (boolean)true);
                    } else if (expressionValue.trim().length() > 0) {
                        setExpression = true;
                        ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)converter.convert(expressionValue), (boolean)true);
                    }
                    if (condition == null || !condition.equals("CONDITION")) {
                        condition = "CONDITION";
                        SetValueCmd cmdCondition = new SetValueCmd((EObject)transition, (EStructuralFeature)CWM_PKG.getTransitionType_Condition(), (Object)condition);
                        command.add((Command)cmdCondition);
                    }
                    if (!setExpression) continue;
                    SetValueCmd cmdExpression = new SetValueCmd((EObject)transition, (EStructuralFeature)CWM_PKG.getTransitionType_Expression(), (Object)expression);
                    command.add((Command)cmdExpression);
                    continue;
                }
                if (expression == null) continue;
                SetValueCmd cmdExpression = new SetValueCmd((EObject)transition, (EStructuralFeature)CWM_PKG.getTransitionType_Expression(), null);
                command.add((Command)cmdExpression);
            }
        }
        for (ProcessDefinitionType process : model.getProcessDefinition()) {
            for (final DiagramType diagram : process.getDiagram()) {
                DiagramModeType mode;
                PoolSymbol pool;
                int maxNumPools = 1;
                if (diagram.getPoolSymbols().size() > maxNumPools) {
                    this.createMergePoolsCmd(diagram, command);
                }
                if (!diagram.getNodes().isEmpty()) {
                    this.moveSymbolsToContainer(command, (ISymbolContainer)diagram, null, -23L, -1L);
                }
                if (!diagram.getConnections().isEmpty()) {
                    this.moveConnectionsToDefaultPool((ISymbolContainer)diagram, command);
                }
                if ((pool = DiagramUtil.getDefaultPool((DiagramType)diagram)) != null) {
                    this.checkLaneParticipant((ISwimlaneSymbol)pool, command);
                }
                if (!(mode = diagram.getMode()).equals((Object)DiagramModeType.MODE_400_LITERAL) || pool == null || pool.getLanes().isEmpty()) continue;
                SetValueCmd cmd = new SetValueCmd((EObject)diagram, (EStructuralFeature)CWM_PKG.getDiagramType_Mode(), (Object)DiagramModeType.MODE_450_LITERAL);
                command.add((Command)cmd);
                if (this.containsSymbols((ISwimlaneSymbol)pool)) {
                    command.add(this.createLaneCmd((ISwimlaneSymbol)pool));
                }
                this.checkLaneActions(pool, command, true);
                DelegatingCommand reorder = new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        PoolSymbol pool = DiagramUtil.getDefaultPool((DiagramType)diagram);
                        return PoolLaneUtils.updateProcessDiagram((ISwimlaneSymbol)pool);
                    }
                };
                command.add((Command)reorder);
                this.checkLaneActions(pool, command, false);
            }
        }
        return command.isEmpty() ? null : command.unwrap();
    }

    public void checkLaneParticipant(ISwimlaneSymbol container, CompoundCommand cmd) {
        EList childLanes = container.getChildLanes();
        if (!childLanes.isEmpty()) {
            ListIterator i = childLanes.listIterator();
            while (i.hasNext()) {
                LaneSymbol lane = (LaneSymbol)i.next();
                IModelParticipant participant = lane.getParticipant();
                if (participant != null) {
                    cmd.add((Command)new SetValueCmd((EObject)lane, (EStructuralFeature)CWM_PKG.getISwimlaneSymbol_ParticipantReference(), (Object)participant));
                    cmd.add((Command)new DeleteValueCmd((EObject)lane, (EStructuralFeature)CWM_PKG.getISwimlaneSymbol_Participant()));
                }
                this.checkLaneParticipant((ISwimlaneSymbol)lane, cmd);
            }
        }
    }

    public void checkLaneActions(PoolSymbol pool, CompoundCommand cmd, boolean create) {
        ListIterator i = pool.getLanes().listIterator();
        while (i.hasNext()) {
            LaneSymbol lane = (LaneSymbol)i.next();
            this.checkLanes((ISwimlaneSymbol)lane, cmd, create);
        }
    }

    private void checkLanes(final ISwimlaneSymbol container, CompoundCommand cmd, boolean create) {
        EList childLanes = container.getChildLanes();
        if (!childLanes.isEmpty()) {
            if (create) {
                if (this.containsSymbols(container)) {
                    cmd.add(this.createLaneCmd(container));
                }
            } else {
                DelegatingCommand reorder = new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.updateProcessDiagram(container);
                    }
                };
                cmd.add((Command)reorder);
            }
            ListIterator i = childLanes.listIterator();
            while (i.hasNext()) {
                LaneSymbol lane = (LaneSymbol)i.next();
                this.checkLanes((ISwimlaneSymbol)lane, cmd, create);
            }
        }
    }

    private boolean containsSymbols(ISwimlaneSymbol container) {
        FeatureMap.ValueListIterator i = ((ISymbolContainer)container).getNodes().valueListIterator();
        while (i.hasNext()) {
            INodeSymbol node = (INodeSymbol)i.next();
            if (node instanceof ISwimlaneSymbol) continue;
            return true;
        }
        return false;
    }

    private void createMergePoolsCmd(DiagramType diagram, CompoundCommand command) {
        for (PoolSymbol pool : diagram.getPoolSymbols()) {
            if (DiagramUtil.isDefaultPool((ISwimlaneSymbol)pool)) continue;
            this.moveSymbolsToContainer(command, (ISymbolContainer)pool, (ISymbolContainer)diagram, pool.getXPos(), pool.getYPos());
            this.moveConnectionsToDefaultPool((ISymbolContainer)pool, command);
            command.add((Command)new DeleteNodeSymbolCmd((INodeSymbol)pool));
        }
    }

    private Dimension moveSymbolsToContainer(CompoundCommand command, final ISymbolContainer container, final ISymbolContainer target, long xPos, long yPos) {
        int defaultSize = 50;
        int x = 0;
        int y = 0;
        FeatureMap.ValueListIterator i = container.getNodes().valueListIterator();
        while (i.hasNext()) {
            final INodeSymbol node = (INodeSymbol)i.next();
            int nodeWidth = node.getWidth();
            int nodeHeight = node.getHeight();
            if (nodeWidth == -1) {
                nodeWidth = defaultSize;
            }
            if (nodeHeight == -1) {
                nodeHeight = defaultSize;
            }
            if (node.getXPos() + (long)nodeWidth + (long)PoolLaneUtils.space > (long)x) {
                x = (int)node.getXPos() + nodeWidth + PoolLaneUtils.space;
            }
            if (node.getYPos() + (long)nodeHeight + (long)PoolLaneUtils.space > (long)y) {
                y = (int)node.getYPos() + nodeHeight + PoolLaneUtils.space;
            }
            if (node instanceof ISwimlaneSymbol) continue;
            CompoundCommand moveSymbolsCmd = new CompoundCommand();
            if (node.eContainmentFeature() == null) continue;
            moveSymbolsCmd.add((Command)new DelegatingCommand(){

                @Override
                public Command createDelegate() {
                    SetSymbolContainerCommand cmd = new SetSymbolContainerCommand(){

                        @Override
                        public boolean changePerformer() {
                            return false;
                        }
                    };
                    if (target == null) {
                        cmd.setContainer((ISymbolContainer)UpdateProcessDiagramAction.this.defaultPoolsMap.get(container), null);
                    } else {
                        cmd.setContainer(target, null);
                    }
                    cmd.setSymbol((IGraphicalObject)node);
                    return cmd;
                }
            });
            moveSymbolsCmd.add((Command)new SetValueCmd((EObject)node, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_XPos(), (Object)new Long(node.getXPos() + xPos)));
            moveSymbolsCmd.add((Command)new SetValueCmd((EObject)node, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_YPos(), (Object)new Long(node.getYPos() + yPos)));
            command.add((Command)moveSymbolsCmd);
        }
        return new Dimension(x, y);
    }

    private void moveConnectionsToDefaultPool(final ISymbolContainer container, CompoundCommand command) {
        FeatureMap.ValueListIterator i = container.getConnections().valueListIterator();
        while (i.hasNext()) {
            final IConnectionSymbol connection = (IConnectionSymbol)i.next();
            if (connection.eContainmentFeature() == null) continue;
            command.add((Command)new DelegatingCommand(){

                @Override
                public Command createDelegate() {
                    SetSymbolContainerCommand cmd = new SetSymbolContainerCommand();
                    cmd.setContainer((ISymbolContainer)UpdateProcessDiagramAction.this.defaultPoolsMap.get(container), null);
                    cmd.setSymbol((IGraphicalObject)connection);
                    return cmd;
                }
            });
        }
    }

    private Command createLaneCmd(final ISwimlaneSymbol container) {
        CompoundCommand compoundCommand = new CompoundCommand();
        CreationFactory factory = NodeCreationFactory.getLaneFactory();
        final IDiagramCommand command = (IDiagramCommand)factory.getNewObject();
        command.setParent((EObject)container);
        command.setLocation(new Rectangle(0, 0, -1, -1));
        compoundCommand.add((Command)command);
        compoundCommand.add((Command)new DelegatingCommand(){

            @Override
            public Command createDelegate() {
                LaneSymbol lane = (LaneSymbol)((CreateSymbolCommand)command).getModelElement();
                CompoundCommand command2 = new CompoundCommand();
                Dimension dimension = UpdateProcessDiagramAction.this.moveSymbolsToContainer(command2, (ISymbolContainer)container, (ISymbolContainer)lane, 0L, 0L);
                lane.setWidth(dimension.width);
                lane.setHeight(dimension.height);
                return command2;
            }
        });
        return compoundCommand;
    }

    private Command createDefaultPoolCmd(ModelType model, final DiagramType diagram) {
        CreateSymbolCommand command = new CreateSymbolCommand(4, null, CarnotWorkflowModelPackage.eINSTANCE.getPoolSymbol()){

            @Override
            protected IModelElement createModelElement() {
                PoolSymbol defaultPool = DiagramUtil.createDefaultPool(null);
                UpdateProcessDiagramAction.this.defaultPoolsMap.put(diagram, defaultPool);
                return defaultPool;
            }
        };
        command.setParent((EObject)diagram);
        command.setLocation(new Rectangle(0, 0, -1, -1));
        return command;
    }

    private boolean checkDefaultPool(DiagramType diagram) {
        PoolSymbol defaultPool = DiagramUtil.getDefaultPool((DiagramType)diagram);
        if (defaultPool != null) {
            this.defaultPoolsMap.put(diagram, defaultPool);
            return true;
        }
        return false;
    }
}

