/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CommandUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ModifyConnectionSymbolCommand;

public class RefreshStartingEventsCommand
extends DiagramCommand {
    private static final String IS_EVENT = "1";
    private static final String START_ACTIVITY_ATTR = "carnot:engine:controlflow.startActivity";
    private static final String END_ACTIVITY_ATTR = "carnot:engine:controlflow.endActivity";
    private CompoundCommand operations = new CompoundCommand();

    public RefreshStartingEventsCommand() {
        super(4, null, null);
    }

    @Override
    public void execute() {
        List startingEvents = CommandUtils.getSymbols((ISymbolContainer)this.getContainer(), CarnotWorkflowModelPackage.eINSTANCE.getStartEventSymbol());
        List endingEvents = CommandUtils.getSymbols((ISymbolContainer)this.getContainer(), CarnotWorkflowModelPackage.eINSTANCE.getEndEventSymbol());
        ProcessDefinitionType process = this.getProcess();
        if (!(process == null || startingEvents.isEmpty() && endingEvents.isEmpty())) {
            CreateConnectionSymbolCommand create;
            ModifyConnectionSymbolCommand modify;
            Iterator connItr;
            TransitionConnectionType connection2;
            ArrayList<String> startingIds = new ArrayList<String>(process.getActivity().size());
            for (ActivityType activity : process.getActivity()) {
                startingIds.add(activity.getId());
            }
            ArrayList<String> endingIds = new ArrayList<String>(process.getActivity().size());
            endingIds.addAll(startingIds);
            Collections.reverse(endingIds);
            for (TransitionType transition : process.getTransition()) {
                if (transition.getTo() != null) {
                    startingIds.remove(transition.getTo().getId());
                }
                if (transition.getFrom() == null) continue;
                endingIds.remove(transition.getFrom().getId());
            }
            ActivitySymbolType startingActivitySymbol = null;
            ActivitySymbolType endingActivitySymbol = null;
            List symbols = CommandUtils.getSymbols((ISymbolContainer)this.getContainer(), CarnotWorkflowModelPackage.eINSTANCE.getActivitySymbolType());
            for (ActivitySymbolType symbol : symbols) {
                if (!startingIds.contains(symbol.getModelElement().getId()) || startingActivitySymbol != null) continue;
                startingActivitySymbol = symbol;
            }
            Collections.reverse(symbols);
            for (ActivitySymbolType symbol : symbols) {
                if (!endingIds.contains(symbol.getModelElement().getId()) || endingActivitySymbol != null) continue;
                endingActivitySymbol = symbol;
            }
            for (StartEventSymbol eventSymbol : startingEvents) {
                if (startingActivitySymbol == null) {
                    for (TransitionConnectionType connection2 : eventSymbol.getOutTransitions()) {
                        this.operations.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)connection2));
                    }
                    continue;
                }
                connItr = eventSymbol.getOutTransitions().iterator();
                if (connItr.hasNext()) {
                    while (connItr.hasNext()) {
                        connection2 = (TransitionConnectionType)connItr.next();
                        if (eventSymbol.equals(connection2.getSourceActivitySymbol()) && startingActivitySymbol.equals(connection2.getTargetActivitySymbol())) continue;
                        modify = new ModifyConnectionSymbolCommand();
                        modify.setConnection((IConnectionSymbol)connection2);
                        modify.setSource((INodeSymbol)eventSymbol);
                        modify.setTarget((INodeSymbol)startingActivitySymbol);
                        this.operations.add((Command)modify);
                    }
                    continue;
                }
                create = new CreateConnectionSymbolCommand(new IdFactory("Transition", Diagram_Messages.BASENAME_Transition), CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType());
                create.setSourceSymbol((INodeSymbol)eventSymbol);
                AttributeUtil.setAttribute((IExtensibleElement)startingActivitySymbol.getModelElement(), (String)START_ACTIVITY_ATTR, (String)IS_EVENT);
                create.setTargetSymbol((INodeSymbol)startingActivitySymbol);
                create.setParent((EObject)this.getDiagram());
                create.setLocation(this.location);
                this.operations.add((Command)create);
            }
            for (StartEventSymbol eventSymbol : endingEvents) {
                if (endingActivitySymbol == null) {
                    for (TransitionConnectionType connection2 : eventSymbol.getInTransitions()) {
                        this.operations.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)connection2));
                    }
                    continue;
                }
                connItr = eventSymbol.getInTransitions().iterator();
                if (connItr.hasNext()) {
                    while (connItr.hasNext()) {
                        connection2 = (TransitionConnectionType)connItr.next();
                        if (eventSymbol.equals(connection2.getTargetActivitySymbol()) && endingActivitySymbol.equals(connection2.getSourceActivitySymbol())) continue;
                        modify = new ModifyConnectionSymbolCommand();
                        modify.setConnection((IConnectionSymbol)connection2);
                        modify.setSource((INodeSymbol)endingActivitySymbol);
                        modify.setTarget((INodeSymbol)eventSymbol);
                        this.operations.add((Command)modify);
                    }
                    continue;
                }
                create = new CreateConnectionSymbolCommand(new IdFactory("Transition", Diagram_Messages.BASENAME_Transition), CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType());
                AttributeUtil.setAttribute((IExtensibleElement)endingActivitySymbol.getModelElement(), (String)END_ACTIVITY_ATTR, (String)IS_EVENT);
                create.setSourceSymbol((INodeSymbol)endingActivitySymbol);
                create.setTargetSymbol((INodeSymbol)eventSymbol);
                create.setParent((EObject)this.getDiagram());
                create.setLocation(this.location);
                this.operations.add((Command)create);
            }
        }
        this.operations.execute();
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public void redo() {
        this.operations.redo();
    }

    @Override
    public void undo() {
        this.operations.undo();
    }

    @Override
    public void dispose() {
        this.operations.dispose();
        this.operations = null;
        super.dispose();
    }
}

