/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.tools;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;

public class SnapCenterToGrid
extends SnapToGrid
implements IPropertyChangeListener {
    public static final int CHANGE_BOTH = 1;
    public static final int CHANGE_DIMENSION = 2;
    public static int CARNOT_DEFAULT_GRID_SIZE = Integer.parseInt(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.snapGridPixel"));
    public static int CARNOT_VISIBLE_GRID_FACTOR = Integer.parseInt(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.visibleGridFactor"));

    public SnapCenterToGrid(GraphicalEditPart container) {
        super(container);
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
        this.setSpacing();
    }

    public void setSpacing() {
        Dimension spacing = (Dimension)this.container.getViewer().getProperty("SnapToGrid.GridSpacing");
        if (spacing == null) {
            if (12 == this.gridX) {
                this.gridX = CARNOT_DEFAULT_GRID_SIZE;
            }
            if (12 == this.gridY) {
                this.gridY = CARNOT_DEFAULT_GRID_SIZE;
            }
        }
    }

    public int snapRectangle(Request request, int snapLocations, PrecisionRectangle rect, PrecisionRectangle result) {
        rect = rect.getPreciseCopy();
        this.makeRelative(this.container.getContentPane(), (Translatable)rect);
        PrecisionRectangle correction = new PrecisionRectangle();
        this.makeRelative(this.container.getContentPane(), (Translatable)correction);
        if (this.gridX > 0 && (snapLocations & 0x10) != 0) {
            this.snapHorizontal(rect, correction, new Integer(2));
            snapLocations &= 0xFFFFFFEF;
        }
        if ((snapLocations & 8) != 0 && this.gridX > 0) {
            this.snapHorizontal(rect, correction, new Integer(1));
            snapLocations &= 0xFFFFFFF7;
        }
        if ((snapLocations & 0x40) != 0 && this.gridX > 0) {
            this.snapHorizontal(rect, correction, null);
            snapLocations &= 0xFFFFFFBF;
        }
        if ((snapLocations & 4) != 0 && this.gridY > 0) {
            this.snapVertical(rect, correction, new Integer(2));
            snapLocations &= 0xFFFFFFFB;
        }
        if ((snapLocations & 1) != 0 && this.gridY > 0) {
            this.snapVertical(rect, correction, new Integer(1));
            snapLocations &= 0xFFFFFFFE;
        }
        if ((snapLocations & 0x80) != 0 && this.gridY > 0) {
            this.snapVertical(rect, correction, null);
            snapLocations &= 0xFFFFFF7F;
        }
        correction.updateInts();
        this.makeAbsolute(this.container.getContentPane(), (Translatable)correction);
        result.preciseX += correction.preciseX;
        result.preciseY += correction.preciseY;
        result.preciseWidth += correction.preciseWidth;
        result.preciseHeight += correction.preciseHeight;
        result.updateInts();
        return snapLocations;
    }

    private void snapVertical(PrecisionRectangle rect, PrecisionRectangle correction, Integer change) {
        double topCorrection = 0.0;
        double heightCorrection = 0.0;
        if (change == null) {
            topCorrection = Math.IEEEremainder(rect.preciseY - (double)this.origin.y, this.gridY);
        } else if (change == 1) {
            topCorrection = Math.IEEEremainder(rect.preciseY - (double)this.origin.y, this.gridY);
            heightCorrection = Math.IEEEremainder(rect.preciseHeight - (double)this.origin.y, this.gridY);
        } else if (change == 2) {
            heightCorrection = Math.IEEEremainder(rect.preciseHeight - (double)this.origin.y, this.gridY);
        }
        correction.preciseHeight -= heightCorrection;
        correction.preciseY -= topCorrection;
    }

    private void snapHorizontal(PrecisionRectangle rect, PrecisionRectangle correction, Integer change) {
        double leftCorrection = 0.0;
        double widthCorrection = 0.0;
        if (change == null) {
            leftCorrection = Math.IEEEremainder(rect.preciseX - (double)this.origin.x, this.gridX);
        } else if (change == 1) {
            leftCorrection = Math.IEEEremainder(rect.preciseX - (double)this.origin.x, this.gridX);
            widthCorrection = Math.IEEEremainder(rect.preciseWidth - (double)this.origin.x, this.gridX);
        } else if (change == 2) {
            widthCorrection = Math.IEEEremainder(rect.preciseWidth - (double)this.origin.x, this.gridX);
        }
        correction.preciseWidth -= widthCorrection;
        correction.preciseX -= leftCorrection;
    }

    public void propertyChange(PropertyChangeEvent event) {
        boolean hasChanged = false;
        if (event.getProperty().equals("org.eclipse.stardust.modeling.common.projectnature.snapGridPixel")) {
            CARNOT_DEFAULT_GRID_SIZE = Integer.parseInt((String)event.getNewValue());
            hasChanged = true;
        }
        if (event.getProperty().equals("org.eclipse.stardust.modeling.common.projectnature.visibleGridFactor")) {
            CARNOT_VISIBLE_GRID_FACTOR = Integer.parseInt((String)event.getNewValue());
            hasChanged = true;
        }
        if (hasChanged) {
            this.setSpacing();
        }
    }
}

