/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.QualityControlType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.javascript.editor.JSCompilationUnitEditor;
import org.eclipse.stardust.modeling.javascript.editor.controller.JavaScriptEditorController;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ActivityQualityControlPropertyPage
extends AbstractModelElementPropertyPage {
    public static final String QUALITY_CONTROL_ID = "_cwm_quality_control_";
    public static final String QUALITY_CONTROL_LABEL = Diagram_Messages.QUALITY_CONTROL_LABEL;
    private Button qualityControl;
    private JSCompilationUnitEditor transitionConditionEditor;
    private JavaScriptEditorController controller = new JavaScriptEditorController();
    private ComboViewer performerViewer;
    private LabeledText createLabeledText;
    protected boolean currentSelection;
    private Combo classCombo;
    private Composite sourceViewerComposite;
    private RoleType createRoleType;
    private String probability;
    private IModelParticipant currentPerformer;
    private Composite composite;

    private void validate() {
        if (this.validateProbability()) {
            this.setErrorMessage(Diagram_Messages.QUALITY_CONTROL_PROBABILITY_VALIDATION);
            this.setValid(false);
        } else if (this.validatePerformer()) {
            this.setErrorMessage(Diagram_Messages.QUALITY_ASSURANCE_PERFORMER_VALIDATION);
            this.setValid(false);
        } else {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    private boolean validateProbability() {
        boolean error = false;
        if (this.currentSelection) {
            if (StringUtils.isEmpty((String)this.probability)) {
                error = true;
            } else {
                try {
                    int parseInt = Integer.parseInt(this.probability);
                    if (parseInt < 0 || parseInt > 100) {
                        error = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    error = true;
                }
            }
        }
        return error;
    }

    private boolean validatePerformer() {
        boolean error = false;
        if (this.currentSelection) {
            if (this.currentPerformer == null) {
                error = true;
            } else if (this.currentPerformer instanceof ConditionalPerformerType) {
                error = true;
            }
        }
        return error;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ActivityType activity = (ActivityType)element;
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        this.controller.intializeModel(model);
        this.refreshDocument();
        this.currentSelection = AttributeUtil.getBooleanValue((IExtensibleElement)activity, (String)"isQualityControlActivity");
        this.qualityControl.setSelection(this.currentSelection);
        this.setFields(false);
        if (this.currentSelection) {
            IModelParticipant qualityControlPerformer = activity.getQualityControlPerformer();
            if (qualityControlPerformer != null) {
                this.performerViewer.setSelection((ISelection)new StructuredSelection((Object)qualityControlPerformer));
            }
            this.createLabeledText.getText().setText(AttributeUtil.getCDataAttribute((IExtensibleElement)activity, (String)"qualityControlProbability"));
            this.transitionConditionEditor.getAdaptedSourceViewer().getTextWidget().setText(AttributeUtil.getCDataAttribute((IExtensibleElement)activity, (String)"qualityControlFormula"));
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        ActivityType activity = (ActivityType)element;
        if (!this.currentSelection) {
            AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"isQualityControlActivity", null);
            activity.setQualityControlPerformer(null);
            AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"qualityControlProbability", null);
            AttributeUtil.setAttribute((IExtensibleElement)activity, (String)"qualityControlFormula", null);
        } else {
            AttributeUtil.setBooleanAttribute((IExtensibleElement)activity, (String)"isQualityControlActivity", (Boolean)true);
            activity.setQualityControlPerformer(this.currentPerformer);
            AttributeUtil.setCDataAttribute((IExtensibleElement)activity, (String)"qualityControlFormula", (String)this.transitionConditionEditor.getAdaptedSourceViewer().getTextWidget().getText());
            AttributeUtil.setCDataAttribute((IExtensibleElement)activity, (String)"qualityControlProbability", (String)this.createLabeledText.getText().getText());
        }
    }

    private void setFields(boolean preselect) {
        ActivityType activity;
        if (!this.currentSelection) {
            this.classCombo.setEnabled(false);
            this.performerViewer.setSelection((ISelection)new StructuredSelection((Object)this.createRoleType));
            this.createLabeledText.getText().setText("");
            this.createLabeledText.getText().setEnabled(false);
            this.transitionConditionEditor.getAdaptedSourceViewer().getTextWidget().setText("");
            this.sourceViewerComposite.setVisible(true);
            this.sourceViewerComposite.setEnabled(false);
            this.composite.setVisible(false);
            activity = (ActivityType)this.getModelElement();
            EList validQualityCodes = activity.getValidQualityCodes();
            if (validQualityCodes != null) {
                validQualityCodes.clear();
            }
        } else {
            this.classCombo.setEnabled(true);
            this.createLabeledText.getText().setEnabled(true);
            this.transitionConditionEditor.getAdaptedSourceViewer().getTextWidget().setText("true");
            this.sourceViewerComposite.setVisible(true);
            this.sourceViewerComposite.setEnabled(true);
            this.composite.setVisible(true);
            if (preselect) {
                this.createLabeledText.getText().setText("100");
                activity = (ActivityType)this.getModelElement();
                ModelType model = ModelUtils.findContainingModel((EObject)activity);
                QualityControlType qualityControlType = model.getQualityControl();
                if (qualityControlType != null) {
                    EList validQualityCodes = activity.getValidQualityCodes();
                    validQualityCodes.addAll((Collection)qualityControlType.getCode());
                }
            }
        }
        PreferenceManager preferenceManager = ((ModelElementPropertyDialog)this.getContainer()).getPreferenceManager();
        IPreferenceNode node = preferenceManager.find("_cwm_quality_control_codes_");
        AbstractModelElementPropertyPage page = (AbstractModelElementPropertyPage)node.getPage();
        page.elementChanged();
    }

    @Override
    public Control createBody(Composite parent) {
        Composite outer = FormBuilder.createComposite((Composite)parent, (int)2);
        this.qualityControl = FormBuilder.createCheckBox((Composite)outer, (String)Diagram_Messages.QUALITY_CONTROL_ACTIVITY, (int)2);
        this.qualityControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityQualityControlPropertyPage.this.currentSelection = ActivityQualityControlPropertyPage.this.qualityControl.getSelection();
                ActivityQualityControlPropertyPage.this.setFields(true);
                ActivityQualityControlPropertyPage.this.validate();
            }
        });
        this.composite = FormBuilder.createComposite((Composite)outer, (int)2);
        FormBuilder.createLabelWithRightAlignedStatus((Composite)this.composite, (String)Diagram_Messages.QUALITY_CONTROL_PARTICIPANT);
        this.classCombo = FormBuilder.createCombo((Composite)this.composite);
        this.performerViewer = new ComboViewer(this.classCombo);
        this.performerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.performerViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IModelParticipant performer = (IModelParticipant)element;
                return performer.getName();
            }
        });
        this.performerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IModelParticipant selection = (IModelParticipant)((IStructuredSelection)ActivityQualityControlPropertyPage.this.performerViewer.getSelection()).getFirstElement();
                if (selection == null || selection.equals(ActivityQualityControlPropertyPage.this.createRoleType)) {
                    ActivityQualityControlPropertyPage.this.currentPerformer = null;
                } else {
                    ActivityQualityControlPropertyPage.this.currentPerformer = selection;
                }
                ActivityQualityControlPropertyPage.this.validate();
            }
        });
        ModelType model = ModelUtils.findContainingModel((EObject)this.getModelElement());
        ArrayList<RoleType> participants = new ArrayList<RoleType>();
        this.createRoleType = CarnotWorkflowModelFactory.eINSTANCE.createRoleType();
        participants.add(this.createRoleType);
        participants.addAll((Collection<RoleType>)model.getRole());
        participants.addAll((Collection<RoleType>)model.getOrganization());
        participants.addAll((Collection<RoleType>)model.getConditionalPerformer());
        this.performerViewer.setInput((Object)participants.toArray());
        this.createLabeledText = FormBuilder.createLabeledText((Composite)this.composite, (String)Diagram_Messages.QUALITY_CONTROL_PROBABILITY);
        this.createLabeledText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ActivityQualityControlPropertyPage.this.probability = ((Text)e.widget).getText();
                ActivityQualityControlPropertyPage.this.validate();
            }
        });
        FormBuilder.createLabel((Composite)this.composite, (String)Diagram_Messages.QUALITY_CONTROL_FORMULA, (int)2);
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IEditorSite editorSite = editor.getEditorSite();
        IFile tempFileResource = GenericUtils.cleanFileStructure(this.getModelElement(), "qualitycontrol.js");
        this.transitionConditionEditor = new JSCompilationUnitEditor();
        this.transitionConditionEditor.setTheSite((IWorkbenchPartSite)editorSite);
        this.transitionConditionEditor.setInput((IEditorInput)new FileEditorInput(tempFileResource));
        this.sourceViewerComposite = new Composite(this.composite, 0);
        GridData svcData = new GridData();
        svcData.grabExcessHorizontalSpace = true;
        svcData.grabExcessVerticalSpace = true;
        svcData.horizontalSpan = 2;
        svcData.horizontalAlignment = 4;
        svcData.verticalAlignment = 4;
        this.sourceViewerComposite.setLayout((Layout)new FillLayout());
        this.sourceViewerComposite.setLayoutData((Object)svcData);
        this.transitionConditionEditor.createPartControl(this.sourceViewerComposite);
        this.transitionConditionEditor.getAdaptedSourceViewer().setEditable(true);
        ((JSCompilationUnitEditor.AdaptedSourceViewer)this.transitionConditionEditor.getAdaptedSourceViewer()).setAutoCompletion(true);
        this.sourceViewerComposite.setEnabled(true);
        this.sourceViewerComposite.setVisible(true);
        this.validate();
        return this.composite;
    }

    public void refreshDocument() {
        this.transitionConditionEditor.getAdaptedSourceViewer().getDocument().set(this.controller.getMasterDocument());
        this.controller.recalculateRegions(this.transitionConditionEditor.getAdaptedSourceViewer().getDocument());
        JSCompilationUnitEditor.RegionWithLineOffset expressionRegion = this.controller.getExpressionRegion();
        this.transitionConditionEditor.getAdaptedSourceViewer().setVisibleRegion(expressionRegion.getOffset(), expressionRegion.getLength());
        this.transitionConditionEditor.setLineOffset(expressionRegion.getLineOffset());
    }
}

