/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.propertyTesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditPartPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("modelElement".equals(property)) {
            return this.testModelElement(receiver, args, expectedValue);
        }
        return false;
    }

    private boolean testModelElement(Object receiver, Object[] args, Object expectedValue) {
        IModelElement element = null;
        if (receiver instanceof IEditorInput) {
            IEditorPart editor;
            IWorkbenchPage page;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null && receiver.equals((editor = page.getActiveEditor()).getEditorInput()) && editor instanceof WorkflowModelEditor) {
                WorkflowModelEditor wme = (WorkflowModelEditor)editor;
                element = wme.getActiveDiagram();
            }
        } else if (receiver instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)receiver;
            element = (IModelElement)adaptable.getAdapter(IModelElement.class);
        }
        if (element != null && expectedValue instanceof String) {
            boolean checkParent = false;
            int i = 0;
            while (i < args.length) {
                if ("checkParent".equals(args[i])) {
                    checkParent = true;
                    break;
                }
                ++i;
            }
            try {
                Class<?> expectedClass = Class.forName((String)expectedValue);
                return this.isInstance(element, expectedClass, checkParent);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    private boolean isInstance(IModelElement element, Class expectedClass, boolean checkParent) {
        boolean result = expectedClass.isInstance(element);
        if (!result && checkParent && element.eContainer() instanceof IModelElement) {
            result = this.isInstance((IModelElement)element.eContainer(), expectedClass, checkParent);
        }
        return result;
    }
}

