/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.dataTypes.primitive;

import com.gface.date.DatePickerCombo;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.BindingManager;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IBindingMediator;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.StructuredViewerAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtButtonAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.SwtComboAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.Verifier;
import org.eclipse.stardust.modeling.core.VerifierFactory;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.SwtDatePickerAdapter;
import org.eclipse.stardust.modeling.core.editors.ui.SwtVerifierTextAdapter;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.ui.PrimitiveDataModelAdapter;
import org.eclipse.stardust.modeling.core.ui.PrimitiveDataWidgetAdapter;
import org.eclipse.stardust.modeling.core.utils.ExtensibleElementValueAdapter;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class PrimitivePropertyPage
extends AbstractModelElementPropertyPage
implements IDataPropertyPage {
    private static final Type[] TYPES = PrimitivePropertyPage.fetchTypes();
    private ComboViewer typeViewer;
    private Composite valueComposite;
    private Map<Type, Object> valueControlsMap = CollectionUtils.newHashMap();
    private Label enumLabel;
    private Tree enumTree;
    private TreeViewer enumViewer;
    private ComboViewer enumComboViewer;
    private Button enumSorter;
    private Label enumSorterLabel;
    protected boolean grouped;

    private static Type[] fetchTypes() {
        List types = Type.getTypes();
        Object[] array = types.toArray(new Type[types.size()]);
        Arrays.sort(array);
        return array;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, final IModelElement element) {
        String dataType = AttributeUtil.getAttributeValue((IExtensibleElement)((DataType)element), (String)"carnot:engine:type");
        String typeId = ((DataType)element).getType().getId();
        if (dataType == null && "struct".equals(typeId)) {
            AttributeUtil.setAttribute((IExtensibleElement)((DataType)element), (String)"carnot:engine:type", (String)"org.eclipse.stardust.engine.core.pojo.data.Type", (String)Type.Enumeration.getId());
        }
        WidgetBindingManager binding = this.getWidgetBindingManager();
        BindingManager mgr = binding.getModelBindingManager();
        mgr.bind((IModelAdapter)new PrimitiveDataModelAdapter(ModelUtils.findContainingModel((EObject)element), Arrays.asList(TYPES), (IExtensibleElement)element), (IWidgetAdapter)new PrimitiveDataWidgetAdapter(this.typeViewer, this.valueComposite, this.valueControlsMap){

            public void updateModel(Object value) {
                super.updateModel(value);
                if (!Type.Enumeration.equals(value)) {
                    ModelType model = ModelUtils.findContainingModel((EObject)element);
                    ((DataType)element).setType(GenericUtils.getDataTypeType(model, "primitive"));
                    AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:defaultValue", null);
                    PrimitivePropertyPage.this.valueComposite.setEnabled(true);
                    AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:dataType", null);
                } else {
                    PrimitivePropertyPage.this.valueComposite.setEnabled(false);
                }
            }
        });
        mgr.bind(WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:type", false), (IWidgetAdapter)this.getSwtComboAdapter());
        mgr.bind(WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:dataType", ExtensibleElementValueAdapter.INSTANCE), (IWidgetAdapter)new StructuredViewerAdapter((StructuredViewer)this.enumViewer){

            public void updateModel(Object value) {
                super.updateModel(value);
                ModelType model = ModelUtils.findContainingModel((EObject)element);
                TypeDeclarationType decl = StructuredTypeUtils.getTypeDeclaration((DataType)((DataType)element));
                if (value == null && decl != null) {
                    this.updateControl(decl);
                }
                if (element.eIsProxy()) {
                    return;
                }
                TypeDeclarationType checkValue = decl;
                if (value != null) {
                    checkValue = (TypeDeclarationType)value;
                }
                if (checkValue != null && TypeDeclarationUtils.isEnumeration((TypeDeclarationType)checkValue, (boolean)false)) {
                    if (TypeDeclarationUtils.isEnumeration((TypeDeclarationType)checkValue, (boolean)true)) {
                        ((DataType)element).setType(GenericUtils.getDataTypeType(model, "primitive"));
                        PrimitivePropertyPage.this.valueComposite.setEnabled(true);
                    } else {
                        ((DataType)element).setType(GenericUtils.getDataTypeType(model, "struct"));
                        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:defaultValue", null);
                        PrimitivePropertyPage.this.valueComposite.setEnabled(false);
                    }
                }
            }
        });
        int i = 0;
        while (i < TYPES.length) {
            Object control = this.valueControlsMap.get(TYPES[i]);
            if (TYPES[i].equals((Object)Type.Timestamp) || TYPES[i].equals((Object)Type.Calendar)) {
                Button resetBtn = null;
                DatePickerCombo datePickerCombo = ((DatePickerComposite)control).getCalendarCombo();
                resetBtn = ((DatePickerComposite)control).getResetBtn();
                mgr.bind(WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:defaultValue", false), (IWidgetAdapter)this.getSwtDatePickerAdapter(datePickerCombo, resetBtn));
            } else if (TYPES[i].equals((Object)Type.Boolean)) {
                Button button = (Button)control;
                mgr.bind(WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:defaultValue", false), (IWidgetAdapter)this.getSwtButtonAdapter(button));
            } else if (TYPES[i].equals((Object)Type.Enumeration)) {
                IModelAdapter modelAdapter = WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:defaultValue", false);
                mgr.bind(modelAdapter, (IWidgetAdapter)new SwtComboAdapter((Combo)control));
                IStructuredSelection selection = (IStructuredSelection)this.enumComboViewer.getSelection();
                if (!selection.isEmpty()) {
                    if (element.eIsProxy()) {
                        return;
                    }
                    Object item = selection.getFirstElement();
                    modelAdapter.updateModel(item);
                }
            } else {
                Type type = TYPES[i];
                Text text = (Text)control;
                mgr.bind(WidgetBindingManager.createModelAdapter((IExtensibleElement)element, "carnot:engine:defaultValue", false), (IWidgetAdapter)this.getSwtVerifierTextAdapter(type, text));
            }
            ++i;
        }
        if (this.isPredefined(element)) {
            this.disableControls();
        }
    }

    private SwtVerifierTextAdapter getSwtVerifierTextAdapter(final Type type, Text text) {
        return new SwtVerifierTextAdapter(text){

            public void updateControl(Object value) {
                Type selectedType = (Type)((IStructuredSelection)PrimitivePropertyPage.this.typeViewer.getSelection()).getFirstElement();
                if (type.equals((Object)selectedType)) {
                    super.updateControl(value);
                }
            }
        };
    }

    private SwtButtonAdapter getSwtButtonAdapter(Button b) {
        return new SwtButtonAdapter(b){

            public void bind(IBindingMediator manager) {
                super.bind(manager);
                final Button button = (Button)this.getWidget();
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.updateModel(button.getSelection() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                    }
                });
            }

            public void updateControl(Object value) {
                Type selectedType;
                if (value != null && !(value instanceof Boolean)) {
                    Object object = value = "true".equalsIgnoreCase(value.toString()) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (Type.Boolean.equals((Object)(selectedType = (Type)((IStructuredSelection)PrimitivePropertyPage.this.typeViewer.getSelection()).getFirstElement()))) {
                    super.updateControl(value);
                }
            }
        };
    }

    private SwtDatePickerAdapter getSwtDatePickerAdapter(DatePickerCombo datePickerCombo, Button resetBtn) {
        return new SwtDatePickerAdapter(datePickerCombo, resetBtn){

            @Override
            public void updateControl(Object value) {
                Type selectedType = (Type)((IStructuredSelection)PrimitivePropertyPage.this.typeViewer.getSelection()).getFirstElement();
                if (Type.Calendar.equals((Object)selectedType) || Type.Timestamp.equals((Object)selectedType)) {
                    super.updateControl(value);
                }
            }
        };
    }

    private SwtComboAdapter getSwtComboAdapter() {
        return new SwtComboAdapter(this.typeViewer.getCombo()){

            public void updateControl(Object value) {
                super.updateControl(value);
                Type selectedType = (Type)((IStructuredSelection)PrimitivePropertyPage.this.typeViewer.getSelection()).getFirstElement();
                selectedType = selectedType == null ? Type.String : selectedType;
                Object object = PrimitivePropertyPage.this.valueControlsMap.get(selectedType);
                ((StackLayout)((PrimitivePropertyPage)PrimitivePropertyPage.this).valueComposite.getLayout()).topControl = object instanceof DatePickerComposite ? ((DatePickerComposite)object).getCalendarComposite() : (Control)object;
                PrimitivePropertyPage.this.valueComposite.layout();
                PrimitivePropertyPage.this.exclude(selectedType != Type.Enumeration, new Control[]{PrimitivePropertyPage.this.enumLabel, PrimitivePropertyPage.this.enumTree, PrimitivePropertyPage.this.enumSorterLabel, PrimitivePropertyPage.this.enumSorter});
                PrimitivePropertyPage.this.enumLabel.getParent().layout();
            }
        };
    }

    private void exclude(boolean exclude, Control ... controls) {
        if (controls != null) {
            Control[] controlArray = controls;
            int n = controls.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                GridData gd = (GridData)control.getLayoutData();
                gd.exclude = exclude;
                control.setVisible(!exclude);
                ++n2;
            }
        }
    }

    private void disableControls() {
        this.typeViewer.getCombo().setEnabled(false);
        for (Object obj : this.valueControlsMap.values()) {
            Control control;
            Object object = control = obj instanceof DatePickerComposite ? ((DatePickerComposite)obj).getCalendarComposite() : (Control)obj;
            if (control instanceof Text) {
                ((Text)control).setEditable(false);
                continue;
            }
            if (control instanceof Button) {
                ((Button)control).setEnabled(false);
                continue;
            }
            if (!(control instanceof DatePickerCombo)) continue;
            ((DatePickerCombo)control).setEnabled(false);
        }
        this.enumTree.setEnabled(false);
    }

    private boolean isPredefined(IModelElement element) {
        return ((DataType)element).isPredefined();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        String typeId = ((DataType)element).getType().getId();
        if ("struct".equals(typeId)) {
            AttributeUtil.setAttribute((IExtensibleElement)((DataType)element), (String)"carnot:engine:type", null);
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_SPI_Type);
        this.typeViewer = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object type) {
                return ((Type)type).getId();
            }
        });
        this.enumLabel = FormBuilder.createLabel((Composite)composite, (String)"Structure: ");
        this.enumTree = this.createEnumTree(composite);
        this.enumViewer = this.createEnumViewer(this.enumTree);
        this.enumSorterLabel = FormBuilder.createLabel((Composite)composite, (String)"");
        this.enumSorter = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.LB_GroupModelElements);
        this.enumSorter.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PrimitivePropertyPage.this.grouped = PrimitivePropertyPage.this.enumSorter.getSelection();
                PrimitivePropertyPage.this.enumViewer.refresh(true);
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.LB_DefaultValue);
        this.valueComposite = new Composite(composite, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        if (this.typeViewer.getCombo().getBounds().height > 0) {
            gd.heightHint = this.typeViewer.getCombo().getBounds().height;
        }
        gd.horizontalAlignment = 4;
        this.valueComposite.setLayoutData((Object)gd);
        StackLayout layout = new StackLayout();
        this.valueComposite.setLayout((Layout)layout);
        this.valueControlsMap.put(TYPES[0], this.createDatePickerComposite());
        Combo enumCombo = FormBuilder.createCombo((Composite)this.valueComposite);
        this.enumComboViewer = new ComboViewer(enumCombo);
        this.enumComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.valueControlsMap.put(TYPES[1], enumCombo);
        this.valueControlsMap.put(TYPES[2], FormBuilder.createText((Composite)this.valueComposite));
        this.valueControlsMap.put(TYPES[3], this.createDatePickerComposite());
        this.valueControlsMap.put(TYPES[4], new Button(this.valueComposite, 32));
        this.valueControlsMap.put(TYPES[5], this.createVerifiedText(VerifierFactory.byteVerifier));
        this.valueControlsMap.put(TYPES[6], this.createLimitedText(1));
        this.valueControlsMap.put(TYPES[7], this.createVerifiedText(VerifierFactory.doubleVerifier));
        this.valueControlsMap.put(TYPES[8], this.createVerifiedText(VerifierFactory.floatVerifier));
        this.valueControlsMap.put(TYPES[9], this.createVerifiedText(VerifierFactory.intVerifier));
        this.valueControlsMap.put(TYPES[10], this.createVerifiedText(VerifierFactory.longVerifier));
        this.valueControlsMap.put(TYPES[11], this.createVerifiedText(VerifierFactory.shortVerifier));
        return composite;
    }

    private Tree createEnumTree(Composite parent) {
        Tree tree = FormBuilder.createTree((Composite)parent, (int)67588);
        tree.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        return tree;
    }

    private TreeViewer createEnumViewer(Tree tree) {
        final TreeViewer viewer = new TreeViewer(tree);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)this.getEnumContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        viewer.setSorter(new ViewerSorter());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object value;
                Object[] facets = StructuredTypeUtils.emptyArray;
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                if (!selection.isEmpty() && (value = selection.getFirstElement()) instanceof TypeDeclarationType) {
                    Object[] content = StructuredTypeUtils.emptyArray;
                    content = StructuredTypeUtils.getFacets((TypeDeclarationType)((TypeDeclarationType)value));
                    facets = new Object[content.length + 1];
                    facets[0] = "";
                    System.arraycopy(content, 0, facets, 1, content.length);
                }
                PrimitivePropertyPage.this.enumComboViewer.setInput((Object)facets);
                if (facets.length > 0) {
                    PrimitivePropertyPage.this.enumComboViewer.setSelection((ISelection)new StructuredSelection(facets[0]), true);
                }
            }
        });
        viewer.setInput(Collections.singleton(this.getEditor().getWorkflowModel()));
        return viewer;
    }

    private ITreeContentProvider getEnumContentProvider() {
        return new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                List result = CollectionUtils.newList();
                if (inputElement instanceof Collection) {
                    for (Object object : (Collection)inputElement) {
                        this.addContent(result, object);
                    }
                } else {
                    this.addContent(result, inputElement);
                }
                return result.isEmpty() ? StructuredTypeUtils.emptyArray : result.toArray();
            }

            private void addContent(final List<EObject> result, Object inputElement) {
                if (inputElement instanceof ModelType) {
                    ModelType model = (ModelType)inputElement;
                    if (PrimitivePropertyPage.this.grouped) {
                        this.addModel(result, model);
                        ModelUtils.forEachReferencedModel((ModelType)model, (Predicate)new Predicate<ModelType>(){

                            public boolean accept(ModelType externalModel) {
                                this.addModel(result, externalModel);
                                return true;
                            }
                        });
                    } else {
                        this.addTypeDeclarations(result, model);
                        ModelUtils.forEachReferencedModel((ModelType)model, (Predicate)new Predicate<ModelType>(){

                            public boolean accept(ModelType externalModel) {
                                this.addTypeDeclarations(result, externalModel);
                                return true;
                            }
                        });
                    }
                }
            }

            private void addTypeDeclarations(List<EObject> result, ModelType model) {
                TypeDeclarationsType declarations = model.getTypeDeclarations();
                if (declarations != null) {
                    for (TypeDeclarationType decl : declarations.getTypeDeclaration()) {
                        if (!TypeDeclarationUtils.isEnumeration((TypeDeclarationType)decl, (boolean)false)) continue;
                        result.add((EObject)decl);
                    }
                }
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ModelType) {
                    List result = CollectionUtils.newList();
                    this.addTypeDeclarations(result, (ModelType)parentElement);
                    return result.toArray();
                }
                return StructuredTypeUtils.emptyArray;
            }

            public Object getParent(Object element) {
                if (element instanceof TypeDeclarationType) {
                    return ModelUtils.findContainingModel((EObject)((EObject)element));
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof ModelType;
            }

            private void addModel(List<EObject> result, ModelType model) {
                TypeDeclarationsType declarations = model.getTypeDeclarations();
                if (declarations != null) {
                    for (TypeDeclarationType decl : declarations.getTypeDeclaration()) {
                        if (!TypeDeclarationUtils.isEnumeration((TypeDeclarationType)decl, (boolean)false)) continue;
                        result.add((EObject)model);
                        break;
                    }
                }
            }
        };
    }

    protected boolean isEnumeration(TypeDeclarationType decl) {
        XSDEnumerationFacet effectiveFacet;
        XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration((TypeDeclarationType)decl);
        if (component instanceof XSDElementDeclaration) {
            component = ((XSDElementDeclaration)component).getTypeDefinition();
        }
        if (component instanceof XSDSimpleTypeDefinition && (effectiveFacet = ((XSDSimpleTypeDefinition)component).getEffectiveEnumerationFacet()) != null) {
            EList values = effectiveFacet.getValue();
            return !values.isEmpty();
        }
        return false;
    }

    private Text createVerifiedText(Verifier verifier) {
        Text text = FormBuilder.createText((Composite)this.valueComposite);
        text.addVerifyListener((VerifyListener)verifier);
        return text;
    }

    private Text createLimitedText(int limit) {
        Text text = FormBuilder.createText((Composite)this.valueComposite);
        text.setTextLimit(limit);
        return text;
    }

    private DatePickerComposite createDatePickerComposite() {
        Composite calendarComposite = new Composite(this.valueComposite, 0);
        GridData gdCal = new GridData();
        gdCal.grabExcessHorizontalSpace = true;
        gdCal.horizontalAlignment = 4;
        calendarComposite.setLayoutData((Object)gdCal);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        calendarComposite.setLayout((Layout)gl);
        GridData gdDP = new GridData();
        gdDP.grabExcessHorizontalSpace = true;
        gdDP.horizontalAlignment = 4;
        DatePickerCombo calendarCombo = new DatePickerCombo(calendarComposite, 2048);
        calendarCombo.setLayoutData((Object)gdDP);
        calendarCombo.setEditable(false);
        calendarCombo.setDateFormat((DateFormat)new SimpleDateFormat(Diagram_Messages.SIMPLE_DATE_FORMAT, Locale.GERMANY));
        Button resetButton = new Button(calendarComposite, 0);
        resetButton.setText(Diagram_Messages.BUT_RESET);
        GridData gdBtn = new GridData();
        gdBtn.grabExcessVerticalSpace = true;
        resetButton.setLayoutData((Object)gdBtn);
        DatePickerComposite datePickerComposite = new DatePickerComposite(calendarComposite, calendarCombo, resetButton);
        return datePickerComposite;
    }

    public class DatePickerComposite {
        private final Composite calendarComposite;
        private final DatePickerCombo calendarCombo;
        private final Button resetBtn;

        public DatePickerComposite(Composite calendarComposite, DatePickerCombo calendarCombo, Button resetBtn) {
            this.calendarComposite = calendarComposite;
            this.calendarCombo = calendarCombo;
            this.resetBtn = resetBtn;
        }

        public Button getResetBtn() {
            return this.resetBtn;
        }

        public Composite getCalendarComposite() {
            return this.calendarComposite;
        }

        public DatePickerCombo getCalendarCombo() {
            return this.calendarCombo;
        }
    }
}

