/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ValidationIssueManager;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.ValidatorRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class VerifyingChangeRecorder
extends ChangeRecorder {
    private final ValidationJob validationTask;
    private final ValidationIssueManager issueManager;
    private ModelType model;
    private IModelElement element;
    private IModelElementNodeSymbol nodeSymbol;

    public VerifyingChangeRecorder(WorkflowModelEditor editor, ValidationIssueManager issueManager) {
        this.validationTask = new ValidationJob(DiagramPlugin.getViewAsPerspectiveId(editor));
        this.issueManager = issueManager;
    }

    public void beginRecording(ModelType model, IModelElement element) {
        this.model = model;
        if (element instanceof IModelElementNodeSymbol) {
            this.nodeSymbol = (IModelElementNodeSymbol)element;
            this.element = this.nodeSymbol.getModelElement();
        } else {
            this.nodeSymbol = null;
            this.element = element;
        }
        super.beginRecording(Collections.singleton(model));
        this.performElementValidation(false);
    }

    public ChangeDescription endRecording() {
        ChangeDescription result = super.endRecording();
        this.dispose();
        this.nodeSymbol = null;
        this.element = null;
        this.model = null;
        return result;
    }

    public void dispose() {
        this.validationTask.cancel();
        super.dispose();
    }

    protected void handleFeature(EStructuralFeature feature, EReference containment, Notification notification, EObject eObject) {
        if (feature.getContainerClass() != null && feature.getContainerClass().getName().equalsIgnoreCase("org.eclipse.xsd.XSDEnumerationFacet") && feature.getEType() != null) {
            feature.getEType().setInstanceClass(String.class);
        }
        super.handleFeature(feature, containment, notification, eObject);
        this.performElementValidation(true);
    }

    public void performElementValidation(boolean delayed) {
        if (!PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoValidation")) {
            return;
        }
        this.validationTask.cancel();
        this.validationTask.schedule(delayed ? 500 : 0);
    }

    private class ValidationJob
    extends Job {
        private Map filters;

        public ValidationJob(String perspectiveId) {
            super(Diagram_Messages.TXT_WorkflowModelValidation);
            this.filters = new HashMap();
            if (perspectiveId != null) {
                this.filters.put("perspectiveType", perspectiveId);
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            Issue[] issues = Issue.ISSUE_ARRAY;
            Issue[] modelIssues = Issue.ISSUE_ARRAY;
            ValidationService vs = ValidationService.getInstance();
            try {
                ValidatorRegistry.setFilters((Map)this.filters);
                vs.setProgressMonitor(monitor);
                if (VerifyingChangeRecorder.this.model != null) {
                    modelIssues = vs.validateModel(VerifyingChangeRecorder.this.model);
                }
                if (VerifyingChangeRecorder.this.element != null) {
                    Issue[] symbolIssues;
                    issues = vs.validateModelElement(VerifyingChangeRecorder.this.element);
                    if (VerifyingChangeRecorder.this.nodeSymbol != null && (symbolIssues = vs.validateModelElement((IModelElement)VerifyingChangeRecorder.this.nodeSymbol)).length > 0) {
                        Issue[] allIssues = new Issue[issues.length + symbolIssues.length];
                        System.arraycopy(issues, 0, allIssues, 0, issues.length);
                        System.arraycopy(symbolIssues, 0, allIssues, issues.length, symbolIssues.length);
                        issues = allIssues;
                    }
                }
                if (modelIssues.length > 0 && VerifyingChangeRecorder.this.element instanceof ModelType) {
                    Issue[] allIssues = new Issue[issues.length + modelIssues.length];
                    System.arraycopy(issues, 0, allIssues, 0, issues.length);
                    System.arraycopy(modelIssues, 0, allIssues, issues.length, modelIssues.length);
                    issues = allIssues;
                }
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                if (VerifyingChangeRecorder.this.issueManager != null) {
                    final Issue[] issuesToBePropagated = issues;
                    Display display = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getDisplay() : Display.getCurrent();
                    if (display != null) {
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                VerifyingChangeRecorder.this.issueManager.resetIssues(issuesToBePropagated);
                            }
                        });
                    } else {
                        VerifyingChangeRecorder.this.issueManager.resetIssues(issuesToBePropagated);
                    }
                }
            }
            finally {
                ValidatorRegistry.setFilters(null);
                vs.setProgressMonitor(null);
            }
            return Status.OK_STATUS;
        }
    }
}

