/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.debugger.ui;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.api.model.AccessPoint;
import org.eclipse.stardust.engine.api.model.Activity;
import org.eclipse.stardust.engine.api.model.ApplicationContext;
import org.eclipse.stardust.engine.api.model.DataMapping;
import org.eclipse.stardust.engine.api.model.ImplementationType;
import org.eclipse.stardust.engine.api.runtime.ActivityCompletionLog;
import org.eclipse.stardust.engine.api.runtime.ActivityInstance;
import org.eclipse.stardust.engine.api.runtime.WorkflowService;
import org.eclipse.stardust.engine.core.extensions.interactive.contexts.jfc.InteractiveApplicationInstance;
import org.eclipse.stardust.engine.core.pojo.data.JavaBeanAccessPathEvaluator;
import org.eclipse.stardust.engine.core.runtime.gui.ApplicationEventListener;
import org.eclipse.stardust.modeling.debug.Internal_Debugger_Messages;
import org.eclipse.stardust.modeling.debug.interpreter.DefaultInterpreter;

public class WorkflowGUIAdapter
extends JInternalFrame {
    private static final long serialVersionUID = 1L;
    private DefaultInterpreter manualInterpreter;
    private Vector listeners = new Vector();
    private InteractiveApplicationInstance applicationInstance;
    private ImplementationType implementationType;

    public Enumeration getAllListeners() {
        return this.listeners.elements();
    }

    public void addToListeners(ApplicationEventListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListenersOnApplicationClose() {
        Enumeration e = this.getAllListeners();
        while (e.hasMoreElements()) {
            ((ApplicationEventListener)e.nextElement()).applicationClosed(null);
        }
    }

    public void cleanupExternalPrograms() {
        if (this.applicationInstance != null) {
            this.applicationInstance.cleanup();
        }
    }

    public JPanel getPanel(WorkflowService service, ActivityInstance activityInstance) {
        if (activityInstance == null) {
            throw new PublicException(Internal_Debugger_Messages.getString("EXP_NoActivitySetOnWorkflowSession"));
        }
        this.implementationType = activityInstance.getActivity().getImplementationType();
        if (this.implementationType == ImplementationType.Manual) {
            return this.getPanelForManualActivity(activityInstance.getActivity().getName());
        }
        if (this.implementationType == ImplementationType.Application) {
            if (!activityInstance.getActivity().isInteractive()) {
                return this.getPanelForNonInteractiveApplication();
            }
            ApplicationContext ctx = activityInstance.getActivity().getApplicationContext("jfc");
            if (ctx == null) {
                return this.getPanelForNonJFCApplication();
            }
            Iterator dataMappingDetails = ctx.getAllInDataMappings().iterator();
            Map inData = service.getInDataValues(activityInstance.getOID(), "jfc", null);
            String instanceClass = (String)ctx.getTypeAttribute("carnot:exdesk:instance");
            this.applicationInstance = (InteractiveApplicationInstance)Reflect.createInstance((String)instanceClass, (Class[])new Class[]{ActivityInstance.class}, (Object[])new Object[]{activityInstance});
            this.processInDataMappings(dataMappingDetails, inData, activityInstance);
            return this.applicationInstance.getPanel();
        }
        throw new InternalException(MessageFormat.format(Internal_Debugger_Messages.getString("EXP_UnsupportedActivityImplType"), this.implementationType));
    }

    private JPanel getPanelForManualActivity(String name) {
        JPanel panel = new JPanel();
        panel.add(new JLabel(Internal_Debugger_Messages.getString("LABEL_ManualActivityInstancesShouldBehandledByEclipse")));
        return panel;
    }

    private JPanel getPanelForNonInteractiveApplication() {
        return new JPanel();
    }

    private JPanel getPanelForNonJFCApplication() {
        JPanel panel = new JPanel();
        panel.add(new JLabel(Internal_Debugger_Messages.getString("LB_InteractiviActivityPanelHasNoJfcContext")));
        return panel;
    }

    private void processInDataMappings(Iterator mappingDetails, Map inData, ActivityInstance activityInstance) {
        while (mappingDetails.hasNext()) {
            DataMapping mapping = (DataMapping)mappingDetails.next();
            Object value = inData.get(mapping.getId());
            AccessPoint accessPoint = mapping.getApplicationAccessPoint();
            if (accessPoint == null) {
                throw new PublicException(MessageFormat.format(Internal_Debugger_Messages.getString("EXP_InvalidDataMappingForActivityInProcess"), mapping.getId(), activityInstance.getActivity().getId(), activityInstance.getProcessDefinitionId()));
            }
            String apID = accessPoint.getId();
            if (StringUtils.isEmpty((String)mapping.getApplicationPath())) {
                this.applicationInstance.setInAccessPointValue(apID, value);
                continue;
            }
            Object accessPointValue = this.applicationInstance.getOutAccessPointValue(apID);
            JavaBeanAccessPathEvaluator evaluator = new JavaBeanAccessPathEvaluator();
            evaluator.evaluate(null, accessPointValue, mapping.getApplicationPath(), value);
        }
    }

    public void completeApplication(WorkflowService session, ActivityInstance activityInstance) {
        this.completeApplication(session, activityInstance, 0);
    }

    public ActivityInstance completeApplication(WorkflowService session, ActivityInstance activityInstance, int flags) {
        ActivityInstance result = null;
        ImplementationType type = activityInstance.getActivity().getImplementationType();
        if (type == ImplementationType.Manual) {
            ActivityCompletionLog log = session.complete(activityInstance.getOID(), "default", this.processManualOutDataMappings(activityInstance.getActivity().getApplicationContext("default").getAllOutDataMappings().iterator()), flags);
            result = log.getNextForUser();
        } else if (type == ImplementationType.Application) {
            if (!activityInstance.getActivity().isInteractive()) {
                return null;
            }
            Activity activity = activityInstance.getActivity();
            ApplicationContext ctx = activity.getApplicationContext("jfc");
            if (ctx == null) {
                JOptionPane.showMessageDialog(null, Internal_Debugger_Messages.getString("MSG_ActivityCannotBeCompletedSinceNoValidJfcContext"));
                return null;
            }
            Map outData = this.applicationInstance.invoke(this.getUsedAccessPoints(ctx.getAllOutDataMappings().iterator()));
            ActivityCompletionLog log = session.complete(activityInstance.getOID(), "jfc", (Map)this.processOutDataMappings(outData, ctx.getAllOutDataMappings().iterator()), flags);
            result = log.getNextForUser();
        } else {
            throw new InternalException(MessageFormat.format(Internal_Debugger_Messages.getString("EXP_UnsupportedActivityImplType"), type));
        }
        return result;
    }

    public Map processApplicationOutDataMappings(WorkflowService session, ActivityInstance activityInstance) {
        return this.processApplicationOutDataMappings(session, activityInstance, 0);
    }

    private Map processApplicationOutDataMappings(WorkflowService session, ActivityInstance activityInstance, int flags) {
        HashMap result = new HashMap();
        ImplementationType type = activityInstance.getActivity().getImplementationType();
        if (type == ImplementationType.Application) {
            if (activityInstance.getActivity().isInteractive()) {
                Activity activity = activityInstance.getActivity();
                ApplicationContext ctx = activity.getApplicationContext("jfc");
                if (ctx == null) {
                    JOptionPane.showMessageDialog(null, Internal_Debugger_Messages.getString("MSG_ActivityCannotBeCompletedSinceNoValidJfcContext"));
                    return null;
                }
                Map outAccessPoints = this.applicationInstance.invoke(this.getUsedAccessPoints(ctx.getAllOutDataMappings().iterator()));
                result = this.processOutDataMappings(outAccessPoints, ctx.getAllOutDataMappings().iterator());
            }
        } else {
            throw new InternalException(MessageFormat.format(Internal_Debugger_Messages.getString("EXP_UnsupportedActivityImplType"), type));
        }
        return result;
    }

    private Iterator getUsedAccessPoints(Iterator outMappings) {
        HashSet<AccessPoint> result = new HashSet<AccessPoint>();
        while (outMappings.hasNext()) {
            DataMapping dataMapping = (DataMapping)outMappings.next();
            AccessPoint accessPoint = dataMapping.getApplicationAccessPoint();
            if (accessPoint == null) continue;
            result.add(accessPoint);
        }
        return result.iterator();
    }

    private HashMap processOutDataMappings(Map outAccessPoints, Iterator outMappings) {
        HashMap<String, Object> outData = new HashMap<String, Object>();
        while (outMappings.hasNext()) {
            String apID;
            Object outAccessPoint;
            DataMapping mapping = (DataMapping)outMappings.next();
            AccessPoint ap = mapping.getApplicationAccessPoint();
            if (ap == null || (outAccessPoint = outAccessPoints.get(apID = ap.getId())) == null) continue;
            JavaBeanAccessPathEvaluator evaluator = new JavaBeanAccessPathEvaluator();
            Object value = evaluator.evaluate(null, outAccessPoint, mapping.getApplicationPath());
            outData.put(mapping.getId(), value);
        }
        return outData;
    }

    public Map processManualOutDataMappings(Iterator outMappings) {
        Map values = null;
        HashMap outData = new HashMap();
        while (outMappings.hasNext()) {
            DataMapping mapping = (DataMapping)outMappings.next();
            outData.put(mapping.getId(), values.get(mapping.getId()));
        }
        return outData;
    }
}

