/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.debug.model.ui;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.engine.core.struct.IXPathMap;
import org.eclipse.stardust.engine.core.struct.StructuredDataValueFactory;
import org.eclipse.stardust.engine.core.struct.StructuredDataXPathUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.modeling.debug.Debug_Messages;
import org.eclipse.stardust.modeling.debug.model.ui.StructuredValue;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StructuredDetailsPanel
extends Composite {
    private final StructuredValue parentValue;
    private final IXPathMap xPathMap;

    public StructuredDetailsPanel(Composite parent, StructuredValue parentValue, IXPathMap xPathMap, ModifyListener dataModificationListener, boolean supportsValueModification) {
        super(parent, 0);
        this.xPathMap = xPathMap;
        this.parentValue = parentValue;
        if (parentValue == null) {
            this.setLayout((Layout)new GridLayout(1, false));
            Label label = new Label((Composite)this, 0);
            label.setText(Debug_Messages.MSG_SelectType);
            label.setLayoutData((Object)new GridData(4, 2, true, false));
        } else {
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.setLayout((Layout)layout);
            if (parentValue.getXPath().getType() == -1) {
                Map complexType = (Map)parentValue.getData();
                for (TypedXPath typedXPath : this.xPathMap.getAllXPaths()) {
                    if (!StructuredDataXPathUtils.getParentXPath((String)typedXPath.getXPath()).equals(parentValue.getXPath().getXPath()) || typedXPath.isList() || typedXPath.getType() == -1) continue;
                    this.createPrimitiveGui(typedXPath, complexType.get(StructuredDataXPathUtils.getLastXPathPart((String)typedXPath.getXPath())), dataModificationListener, supportsValueModification);
                }
            } else {
                this.createPrimitiveGui(parentValue.getXPath(), parentValue.getData(), dataModificationListener, supportsValueModification);
            }
        }
    }

    private void createPrimitiveGui(final TypedXPath xPath, Object data, ModifyListener dataModificationListener, boolean supportsValueModification) {
        Label label = new Label((Composite)this, 131072);
        label.setLayoutData((Object)new GridData(4, 2, false, false));
        final String propertyName = StructuredDataXPathUtils.getLastXPathPart((String)xPath.getXPath());
        label.setText(propertyName);
        final Text text = new Text((Composite)this, 2048);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.getFontMetrics(), (int)50);
        text.setLayoutData((Object)layoutData);
        String stringRepresentation = StructuredDataValueFactory.convertToString((int)xPath.getType(), (String)xPath.getXsdTypeName(), (Object)data);
        if (stringRepresentation != null) {
            text.setText(stringRepresentation);
        }
        if (supportsValueModification) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Object objectRepresentation = StructuredDataValueFactory.convertTo((int)xPath.getType(), (String)text.getText());
                    if (xPath.isList() && xPath.getType() != -1) {
                        Map parentMap = (Map)StructuredDetailsPanel.this.parentValue.getParent().getData();
                        List list = (List)parentMap.get(StructuredDataXPathUtils.getLastXPathPart((String)StructuredDetailsPanel.this.parentValue.getXPath().getXPath()));
                        int index = list.indexOf(StructuredDetailsPanel.this.parentValue.getData());
                        list.set(index, objectRepresentation);
                        StructuredDetailsPanel.this.parentValue.setData(objectRepresentation);
                    } else {
                        ((Map)StructuredDetailsPanel.this.parentValue.getData()).put(propertyName, objectRepresentation);
                    }
                }
            });
            text.addModifyListener(dataModificationListener);
        } else {
            text.setEditable(false);
        }
    }

    public FontMetrics getFontMetrics() {
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        FontMetrics fm = gc.getFontMetrics();
        gc.dispose();
        return fm;
    }
}

