/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.deploy;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.stardust.common.Base64;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmCoreLibrariesClasspathContainer;
import org.eclipse.stardust.modeling.deploy.Deploy_Messages;
import org.eclipse.stardust.modeling.deploy.ModelDeploymentTool;
import org.eclipse.ui.PlatformUI;

public class DeployUtil {
    private static final String DUSER_REGION_ARG = " -Duser.region=";
    private static final String DUSER_LANGUAGE_ARG = " -Duser.language=";

    public static boolean deployModel(List<IResource> resources, String carnotHome, String carnotWork) {
        boolean deployed = false;
        if (resources != null && !resources.isEmpty()) {
            try {
                IProject project = DeployUtil.getCommonProject(resources);
                ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                ILaunchConfigurationType type = manager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
                ILaunchConfigurationWorkingCopy wc = type.newInstance(null, "Infinity Process Model Deployment");
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.stardust.modeling.common.projectnature.deployModelClasspathProvider");
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, ModelDeploymentTool.class.getName());
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-Xms50m -Xmx256m" + DeployUtil.getLocaleArgs());
                boolean version = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturedeployVersion");
                String realm = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnaturedeployRealm");
                String partition = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnaturedeployPartition");
                String user = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnaturedeployId");
                String password = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnaturedeployPassword");
                String domain = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnaturedeployDomain");
                StringBuilder programAttributes = new StringBuilder();
                boolean separator = false;
                for (IResource resource : resources) {
                    try {
                        String fileName = resource.getLocation().toOSString();
                        String encodedFileName = new String(Base64.encode((byte[])fileName.getBytes("UTF-8")));
                        DeployUtil.addArgument(programAttributes, "filename64", encodedFileName, false, separator);
                        separator = true;
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                if (version) {
                    DeployUtil.addArgument(programAttributes, "version", Boolean.TRUE.toString(), false, true);
                }
                if (!StringUtils.isEmpty((String)user) && !StringUtils.isEmpty((String)password)) {
                    DeployUtil.addArgument(programAttributes, "user", user, true, true);
                    DeployUtil.addArgument(programAttributes, "password", password, true, true);
                    if (!StringUtils.isEmpty((String)realm)) {
                        DeployUtil.addArgument(programAttributes, "realm", realm, true, true);
                    }
                    if (!StringUtils.isEmpty((String)partition)) {
                        DeployUtil.addArgument(programAttributes, "partition", partition, true, true);
                    }
                    if (!StringUtils.isEmpty((String)domain)) {
                        DeployUtil.addArgument(programAttributes, "domain", domain, true, true);
                    }
                }
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programAttributes.toString());
                wc.setAttribute("CARNOT_HOME", carnotHome);
                wc.setAttribute("CARNOT_WORK", carnotWork);
                wc.setAttribute("CARNOT_EXTRA_LOCATION", BpmCoreLibrariesClasspathContainer.getLibraryLocation((String)"org.eclipse.stardust.modeling.deploy", (String[])new String[]{"bin", ""}).toString());
                ILaunchConfiguration config = wc.doSave();
                ILaunch toolLaunch = config.launch("run", null);
                deployed = toolLaunch.getProcesses().length > 0;
                config.delete();
                wc.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return deployed;
    }

    private static String getLocaleArgs() {
        String nl = Platform.getNL();
        StringBuilder localeJVMArg = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(nl, "_");
        int token = tokenizer.countTokens();
        String language = Locale.getDefault().getLanguage();
        String country = Locale.getDefault().getCountry();
        if (token > 0) {
            language = tokenizer.nextToken();
            country = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : null;
        }
        localeJVMArg.append(DUSER_LANGUAGE_ARG);
        localeJVMArg.append(language);
        if (StringUtils.isNotEmpty((String)country)) {
            localeJVMArg.append(DUSER_REGION_ARG);
            localeJVMArg.append(country);
        }
        return localeJVMArg.toString();
    }

    private static void addArgument(StringBuilder programAttributes, String name, String value, boolean encode, boolean separator) {
        if (separator) {
            programAttributes.append(' ');
        }
        programAttributes.append("--");
        programAttributes.append(name);
        programAttributes.append(' ');
        programAttributes.append(encode ? new String(Base64.encode((byte[])value.getBytes())) : value);
    }

    private static IProject getCommonProject(List<IResource> resources) throws CoreException {
        IProject project = null;
        for (IResource resource : resources) {
            IProject prj = resource.getProject();
            if (prj == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.deploy", 1, MessageFormat.format(Deploy_Messages.getString("MSG_RESOURCE_NOT_PART_OF_PROJECT"), resource), null));
            }
            if (project == null) {
                project = prj;
                continue;
            }
            if (project == prj) continue;
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.deploy", 1, Deploy_Messages.getString("MSG_REOURCES_DIFFERENT_PROJECTS"), null));
        }
        return project;
    }
}

