/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.ejb30.entity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IDataPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.integration.ejb30.EJB30_Messages;
import org.eclipse.stardust.modeling.integration.ejb30.TypeSelector;
import org.eclipse.stardust.modeling.integration.ejb30.entity.MyASTVisitor;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class EntityBean30PropertyPage
extends AbstractModelElementPropertyPage
implements IDataPropertyPage {
    private static final String CLASS_SUFFIX = ".class";
    private TypeSelector.TextSelector beanClassBrowser;
    private LabeledText beanClassText;
    private LabeledCombo emSourceCombo;
    private LabeledText jndiText;
    private Label pkType;
    private Label pkClass;
    private Label pkElements;

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.beanClassText, (IExtensibleElement)element, "carnot:engine:className");
        wBndMgr.bind(this.emSourceCombo, (IExtensibleElement)element, "carnot:engine:emSource");
        wBndMgr.bind(this.jndiText, (IExtensibleElement)element, "carnot:engine:jndiPath");
        if (this.isPredefined(element)) {
            this.disableControls();
        }
    }

    private void disableControls() {
        this.beanClassBrowser.getTextControl().setEnabled(false);
        this.beanClassText.getText().setEditable(false);
    }

    private boolean isPredefined(IModelElement element) {
        return ((DataType)element).isPredefined();
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:primaryKey", (String)this.pkClass.getText());
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:primaryKeyType", (String)this.pkType.getText());
        AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:primaryKeyElements", (String)this.pkElements.getText());
    }

    public Control createBody(Composite parent) {
        TypeFinder finder = new TypeFinder(this.getModelElement());
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        LabelWithStatus beanLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)EJB30_Messages.LBL_BEAN_CLASS_NAME);
        this.beanClassBrowser = new TypeSelector.TextSelector(finder, composite, EJB30_Messages.TXT_ENTITY_BEAN_CL, 2);
        this.beanClassText = new LabeledText(this.beanClassBrowser.getTextControl(), beanLabel);
        this.beanClassBrowser.addListener(new TypeSelector.TypeListener(){

            @Override
            public void typeChanged(TypeInfo type) {
                EntityBean30PropertyPage.this.updatePkInfo(type);
            }
        });
        this.emSourceCombo = FormBuilder.createLabeledCombo((Composite)composite, (String)EJB30_Messages.LBL_ENTITY_MANAGER);
        this.emSourceCombo.getCombo().setItems(new String[]{EJB30_Messages.LBL_JNDI, EJB30_Messages.LBL_FACTORY_JNDI, EJB30_Messages.LBL_UNIT_NAME});
        this.emSourceCombo.getCombo().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EntityBean30PropertyPage.this.updateJndiLabel();
            }
        });
        this.jndiText = FormBuilder.createLabeledText((Composite)composite, (String)EJB30_Messages.LB_JNDIPath);
        FormBuilder.createLabel((Composite)composite, (String)EJB30_Messages.LBL_PRIMARY_KEY_TYPE);
        this.pkType = FormBuilder.createLabel((Composite)composite, (String)"");
        FormBuilder.createLabel((Composite)composite, (String)EJB30_Messages.LBL_PRIMARY_KEY_CL);
        this.pkClass = FormBuilder.createLabel((Composite)composite, (String)"");
        FormBuilder.createLabel((Composite)composite, (String)EJB30_Messages.LBL_PRIMARY_KEY_ELEMENT);
        this.pkElements = FormBuilder.createLabel((Composite)composite, (String)"");
        return composite;
    }

    protected void updatePkInfo(TypeInfo type) {
        this.pkType.setText("");
        this.pkClass.setText("");
        this.pkElements.setText("");
        if (type != null) {
            String typeName = type.getFullName();
            try {
                Class<?> typeClass = Class.forName(typeName);
                this.updatePkInfoFromClass(typeClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    this.updatePkInfoFromSource(type);
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void updatePkInfoFromClass(Class<?> typeClass) {
        Entity entity = typeClass.getAnnotation(Entity.class);
        if (entity == null) {
            this.setMessage(MessageFormat.format(EJB30_Messages.MSG_TYPE_STELLE_NULL_IS_NOT_ANNTATED, typeClass.getName()), 2);
            return;
        }
        IdClass idClass = typeClass.getAnnotation(IdClass.class);
        if (idClass != null) {
            this.pkType.setText(EJB30_Messages.TXT_ID_CLASS);
            Class pkClass = idClass.value();
            if (pkClass != null) {
                this.pkClass.setText(pkClass.getName());
                StringBuffer sb = new StringBuffer();
                Field[] fields = typeClass.getFields();
                int i = 0;
                while (i < fields.length) {
                    Id id = fields[i].getAnnotation(Id.class);
                    if (id != null) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(EJB30_Messages.TXT_FIELD);
                        sb.append(fields[i].getName());
                    }
                    ++i;
                }
                Method[] methods = typeClass.getMethods();
                int i2 = 0;
                while (i2 < methods.length) {
                    Id id = methods[i2].getAnnotation(Id.class);
                    if (id != null) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(EJB30_Messages.TXT_PROPERTY);
                        sb.append(methods[i2].getName());
                    }
                    ++i2;
                }
                this.pkElements.setText(sb.toString());
            } else {
                this.pkType.setText("");
                this.pkElements.setText("");
            }
        } else {
            Method[] methods;
            EmbeddedId id;
            int i;
            Field[] fields;
            boolean pkFound = false;
            if (!pkFound) {
                fields = typeClass.getFields();
                i = 0;
                while (i < fields.length && !pkFound) {
                    id = fields[i].getAnnotation(EmbeddedId.class);
                    if (id != null) {
                        this.pkType.setText(EJB30_Messages.TXT_EMBEDDED_ID);
                        this.pkClass.setText(fields[i].getType().getName());
                        this.pkElements.setText(MessageFormat.format(EJB30_Messages.TXT_FIELD, fields[i].getName()));
                        pkFound = true;
                    }
                    ++i;
                }
            }
            if (!pkFound) {
                methods = typeClass.getMethods();
                i = 0;
                while (i < methods.length && !pkFound) {
                    id = methods[i].getAnnotation(EmbeddedId.class);
                    if (id != null) {
                        this.pkType.setText(EJB30_Messages.TXT_EMBEDDED_ID);
                        this.pkClass.setText(methods[i].getReturnType().getName());
                        this.pkElements.setText(MessageFormat.format(EJB30_Messages.TXT_PROPERTY, methods[i].getName()));
                        pkFound = true;
                    }
                    ++i;
                }
            }
            if (!pkFound) {
                fields = typeClass.getFields();
                i = 0;
                while (i < fields.length && !pkFound) {
                    id = fields[i].getAnnotation(Id.class);
                    if (id != null) {
                        this.pkType.setText(EJB30_Messages.TXT_ID);
                        this.pkClass.setText(fields[i].getType().getName());
                        this.pkElements.setText(MessageFormat.format(EJB30_Messages.TXT_FIELD, fields[i].getName()));
                        pkFound = true;
                    }
                    ++i;
                }
            }
            if (!pkFound) {
                methods = typeClass.getMethods();
                i = 0;
                while (i < methods.length && !pkFound) {
                    id = methods[i].getAnnotation(Id.class);
                    if (id != null) {
                        this.pkType.setText(EJB30_Messages.TXT_ID);
                        this.pkClass.setText(methods[i].getReturnType().getName());
                        this.pkElements.setText(MessageFormat.format(EJB30_Messages.TXT_PROPERTY, methods[i].getName()));
                        pkFound = true;
                    }
                    ++i;
                }
            }
        }
    }

    private void updatePkInfoFromSource(TypeInfo type) throws JavaModelException {
        TypeDeclaration td = MyASTVisitor.findTypeDeclaration(type);
        Annotation entity = MyASTVisitor.getAnnotation(type, (ASTNode)td, Entity.class);
        if (entity == null) {
            this.setMessage(MessageFormat.format(EJB30_Messages.MSG_TYPE_IS_NOT_ANNOTATED_AS_ENTITY, type.getFullName()), 2);
            return;
        }
        Annotation idClass = MyASTVisitor.getAnnotation(type, (ASTNode)td, IdClass.class);
        if (idClass != null) {
            this.pkType.setText(EJB30_Messages.TXT_ID_CL);
            if (idClass instanceof SingleMemberAnnotation) {
                String pkClass;
                SingleMemberAnnotation sma = (SingleMemberAnnotation)idClass;
                String pkClassName = sma.getValue().toString();
                if (pkClassName.endsWith(CLASS_SUFFIX)) {
                    pkClassName = pkClassName.substring(0, pkClassName.length() - CLASS_SUFFIX.length());
                }
                if ((pkClass = type.resolve(pkClassName)) != null) {
                    this.pkClass.setText(pkClass);
                    StringBuffer sb = new StringBuffer();
                    FieldDeclaration[] fields = td.getFields();
                    int i = 0;
                    while (i < fields.length) {
                        Annotation id = MyASTVisitor.getAnnotation(type, (ASTNode)fields[i], Id.class);
                        if (id != null) {
                            if (sb.length() > 0) {
                                sb.append(',');
                            }
                            sb.append(EJB30_Messages.TXT_FIELD);
                            VariableDeclarationFragment first = (VariableDeclarationFragment)fields[i].fragments().get(0);
                            sb.append(first.getName().toString());
                        }
                        ++i;
                    }
                    MethodDeclaration[] methods = td.getMethods();
                    int i2 = 0;
                    while (i2 < methods.length) {
                        Annotation id = MyASTVisitor.getAnnotation(type, (ASTNode)methods[i2], Id.class);
                        if (id != null) {
                            if (sb.length() > 0) {
                                sb.append(',');
                            }
                            sb.append(EJB30_Messages.TXT_PROPERTY);
                            sb.append(methods[i2].getName().toString());
                        }
                        ++i2;
                    }
                    this.pkElements.setText(sb.toString());
                } else {
                    this.pkType.setText("");
                    this.pkElements.setText("");
                }
            }
        } else {
            String pkClass;
            MethodDeclaration[] methods;
            String pkClass2;
            VariableDeclarationFragment first;
            Annotation id;
            int i;
            FieldDeclaration[] fields;
            boolean pkFound = false;
            if (!pkFound) {
                fields = td.getFields();
                i = 0;
                while (i < fields.length && !pkFound) {
                    id = MyASTVisitor.getAnnotation(type, (ASTNode)fields[i], EmbeddedId.class);
                    if (id != null) {
                        this.pkType.setText(EJB30_Messages.TXT_EMBEDDED_ID);
                        first = (VariableDeclarationFragment)fields[i].fragments().get(0);
                        pkClass2 = type.resolve(fields[i].getType().toString());
                        this.pkClass.setText(pkClass2 == null ? "" : pkClass2);
                        this.pkElements.setText(MessageFormat.format(EJB30_Messages.TXT_FIELD, first.getName().toString()));
                        pkFound = true;
                    }
                    ++i;
                }
            }
            if (!pkFound) {
                methods = td.getMethods();
                i = 0;
                while (i < methods.length && !pkFound) {
                    id = MyASTVisitor.getAnnotation(type, (ASTNode)methods[i], EmbeddedId.class);
                    if (id != null) {
                        this.pkType.setText(EJB30_Messages.TXT_EMBEDDED_ID);
                        pkClass = type.resolve(methods[i].getReturnType2().toString());
                        this.pkClass.setText(pkClass == null ? "" : pkClass);
                        this.pkElements.setText(MessageFormat.format(EJB30_Messages.TXT_PROPERTY, methods[i].getName().toString()));
                        pkFound = true;
                    }
                    ++i;
                }
            }
            if (!pkFound) {
                fields = td.getFields();
                i = 0;
                while (i < fields.length && !pkFound) {
                    id = MyASTVisitor.getAnnotation(type, (ASTNode)fields[i], Id.class);
                    if (id != null) {
                        this.pkType.setText(EJB30_Messages.TXT_ID);
                        first = (VariableDeclarationFragment)fields[i].fragments().get(0);
                        pkClass2 = type.resolve(fields[i].getType().toString());
                        this.pkClass.setText(pkClass2 == null ? "" : pkClass2);
                        this.pkElements.setText(MessageFormat.format(EJB30_Messages.TXT_FIELD, first.getName().toString()));
                        pkFound = true;
                    }
                    ++i;
                }
            }
            if (!pkFound) {
                methods = td.getMethods();
                i = 0;
                while (i < methods.length && !pkFound) {
                    id = MyASTVisitor.getAnnotation(type, (ASTNode)methods[i], Id.class);
                    if (id != null) {
                        this.pkType.setText(EJB30_Messages.TXT_ID);
                        pkClass = type.resolve(methods[i].getReturnType2().toString());
                        this.pkClass.setText(pkClass == null ? "" : pkClass);
                        this.pkElements.setText(MessageFormat.format(EJB30_Messages.TXT_PROPERTY, methods[i].getName().toString()));
                        pkFound = true;
                    }
                    ++i;
                }
            }
        }
    }

    protected void updateJndiLabel() {
        int index = this.emSourceCombo.getCombo().getSelectionIndex();
        this.jndiText.getLabel().setText(index < 2 ? EJB30_Messages.LB_JNDIPath : EJB30_Messages.LBL_UNIT_NAMEE);
    }
}

