/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.integration.ejb30.session;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.Stateful;
import javax.ejb.Stateless;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.integration.ejb30.entity.MyASTVisitor;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;

public class SessionBean30Validator
implements IModelElementValidator {
    private static final String[] methodAttrNames = new String[]{"carnot:engine:createMethodName", "carnot:engine:methodName"};
    private ModelType model;

    public Issue[] validate(IModelElement element) throws ValidationException {
        this.model = (ModelType)element.eContainer();
        ArrayList<Issue> result = new ArrayList<Issue>();
        if (element instanceof ApplicationType) {
            ApplicationType sessionBean = (ApplicationType)element;
            this.checkInterface(result, sessionBean);
            this.checkBean(result, sessionBean);
            this.checkJndiPath(result, (IExtensibleElement)sessionBean);
        }
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private void checkInterface(List<Issue> result, ApplicationType sessionBean) {
        TypeFinder typeFinder = new TypeFinder((EObject)sessionBean);
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)sessionBean, (String)"carnot:engine:remoteInterface");
        className = VariableContextHelper.getInstance().getContext(this.model).replaceAllVariablesByDefaultValue(className);
        if (className == null || StringUtils.isEmpty((String)className.trim())) {
            result.add(Issue.warning((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.MSG_InterfaceNotSpecified, "Business"), (Object)"carnot:engine:remoteInterface"));
        } else {
            TypeInfo rType = typeFinder.findType(className);
            if (rType == null) {
                result.add(Issue.error((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), (Object)"carnot:engine:remoteInterface"));
            } else {
                int i = 0;
                while (i < methodAttrNames.length) {
                    this.checkMethod(result, sessionBean, typeFinder, rType, className, methodAttrNames[i]);
                    ++i;
                }
            }
        }
    }

    private void checkBean(List<Issue> result, ApplicationType sessionBean) {
        TypeFinder typeFinder = new TypeFinder((EObject)sessionBean);
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)sessionBean, (String)"carnot:engine:className");
        className = VariableContextHelper.getInstance().getContext(this.model).replaceAllVariablesByDefaultValue(className);
        if (!StringUtils.isEmpty((String)className)) {
            TypeInfo type = typeFinder.findType(className);
            if (type == null) {
                result.add(Issue.error((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.MSG_ClassCanNotBeResolved, className), (Object)"carnot:engine:className"));
            } else {
                try {
                    TypeDeclaration td = MyASTVisitor.findTypeDeclaration(type);
                    Annotation stateless = MyASTVisitor.getAnnotation(type, (ASTNode)td, Stateless.class);
                    Annotation stateful = MyASTVisitor.getAnnotation(type, (ASTNode)td, Stateful.class);
                    if (stateless == null && stateful == null) {
                        result.add(Issue.warning((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.SessionBean30Validator_MissingAnnotation, type.getFullName()), (Object)"carnot:engine:className"));
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void checkMethod(List<Issue> result, ApplicationType sessionBean, TypeFinder typeFinder, TypeInfo rType, String className, String attributeName) {
        MethodInfo info;
        String method = AttributeUtil.getAttributeValue((IExtensibleElement)sessionBean, (String)attributeName);
        if (!StringUtils.isEmpty((String)method) && (info = typeFinder.getMethod(rType, method)) == null) {
            result.add(Issue.warning((EObject)sessionBean, (String)MessageFormat.format(Validation_Messages.MSG_CantFindMethodInClass, method, className), (Object)attributeName));
        }
    }

    private void checkJndiPath(List<Issue> result, IExtensibleElement element) {
        String jndiPath = AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)"carnot:engine:jndiPath");
        if (jndiPath == null || jndiPath.trim().length() == 0) {
            result.add(Issue.warning((EObject)((IModelElement)element), (String)MessageFormat.format(Validation_Messages.Validation_MSG_JNDIPathNotSpecified, new Object[0]), (Object)"carnot:engine:jndiPath"));
        }
    }
}

