/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.file.search;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.file.File_Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SearchDialog
extends Dialog {
    private Text searchText;
    private String searchString;
    List<IObjectDescriptor> matchedElements = CollectionUtils.newList();

    public SearchDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = (Composite)super.createDialogArea(parent);
        Composite composite = FormBuilder.createComposite((Composite)control, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)File_Messages.LBL_FIND);
        this.searchText = FormBuilder.createText((Composite)composite);
        return control;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getButton(0).setText(File_Messages.BUT_TXT_SEARCH);
        return control;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(File_Messages.TXT_SEARCH);
    }

    protected void okPressed() {
        this.searchString = this.searchText.getText().trim();
        super.okPressed();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public List<IObjectDescriptor> searchEntries(List<IObjectDescriptor> cache) {
        IObjectDescriptor[] descriptors = cache.toArray(new IObjectDescriptor[cache.size()]);
        String[] searchStrings = this.searchString.split(" ");
        if (searchStrings.length > 1) {
            int i = 0;
            while (i < searchStrings.length) {
                this.search(searchStrings[i].toLowerCase(), descriptors);
                ++i;
            }
        } else {
            this.searchString = this.searchString.toLowerCase();
            this.search(this.searchString, descriptors);
        }
        return this.matchedElements.size() == 0 ? null : this.matchedElements;
    }

    private void search(String searchString, IObjectDescriptor[] descriptors) {
        int i = 0;
        while (i < descriptors.length) {
            IObjectDescriptor entry = descriptors[i];
            if (this.normalize(entry.getDescription()).indexOf(searchString) >= 0 || this.normalize(entry.getLabel()).indexOf(searchString) >= 0) {
                this.matchedElements.add(entry);
            } else if (entry instanceof IObjectReference && this.normalize(((IObjectReference)entry).getId()).indexOf(searchString) >= 0) {
                this.matchedElements.add(entry);
            }
            if (entry.hasChildren()) {
                this.search(searchString, entry.getChildren());
            }
            ++i;
        }
    }

    private String normalize(String description) {
        String result = description == null ? "" : description;
        return result.toLowerCase();
    }
}

