/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.defaulttemplate;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.stardust.modeling.templates.defaulttemplate.ClasspathUriConverter;
import org.eclipse.stardust.modeling.templates.defaulttemplate.TemplateAdapter;
import org.eclipse.stardust.modeling.templates.emf.template.DocumentationType;
import org.eclipse.stardust.modeling.templates.emf.template.TemplateLibraryType;
import org.eclipse.stardust.modeling.templates.emf.template.TemplateType;
import org.eclipse.stardust.modeling.templates.emf.template.TemplatesType;
import org.eclipse.stardust.modeling.templates.emf.template.util.TemplateManager;
import org.eclipse.stardust.modeling.templates.spi.ITemplate;
import org.eclipse.stardust.modeling.templates.spi.ITemplateFactory;

public class TemplateFactory
implements ITemplateFactory {
    private static final String XPDL_PARAMETER = "xpdl";
    private static final ClasspathUriConverter CLASSPATH_URI_CONVERTER = new ClasspathUriConverter();
    private TemplateLibraryType templateLibrary;

    protected URIConverter getURIConverter() {
        return CLASSPATH_URI_CONVERTER;
    }

    @Override
    public void initialize(Map parameters) {
        boolean loadingFromClasspath;
        String location = (String)parameters.get(XPDL_PARAMETER);
        URI uri = URI.createURI((String)location);
        if (uri.scheme() == null) {
            loadingFromClasspath = true;
            if (location.startsWith("/")) {
                location = location.substring(1);
            }
            uri = URI.createURI((String)("classpath:/" + location));
        } else {
            loadingFromClasspath = false;
        }
        TemplateManager manager = new TemplateManager(){

            @Override
            protected ResourceSet getResourceSet() {
                ResourceSet resourceSet = super.getResourceSet();
                if (loadingFromClasspath) {
                    resourceSet.setURIConverter(TemplateFactory.this.getURIConverter());
                }
                return resourceSet;
            }
        };
        try {
            manager.load(uri);
            this.templateLibrary = manager.getTemplate();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getId() {
        if (this.templateLibrary != null) {
            return this.templateLibrary.getId();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.templateLibrary != null) {
            return this.templateLibrary.getName();
        }
        return null;
    }

    @Override
    public String getDescription() {
        DocumentationType documentation;
        if (this.templateLibrary != null && (documentation = this.templateLibrary.getDocumentation()) != null) {
            return documentation.getAsText();
        }
        return null;
    }

    @Override
    public ITemplate[] getTemplates() {
        TemplatesType templates;
        if (this.templateLibrary != null && (templates = this.templateLibrary.getTemplates()) != null) {
            EList templateList = templates.getTemplate();
            ITemplate[] result = new ITemplate[templateList.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = new TemplateAdapter((TemplateType)templateList.get(i), this);
                ++i;
            }
            return result;
        }
        return new ITemplate[0];
    }

    public static void main(String[] args) {
        TemplateFactory factory = new TemplateFactory();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(XPDL_PARAMETER, "/com/infinity/bpm/modeling/templates/poc/resources/template.cwmt");
        factory.initialize(parameters);
        System.out.println(factory.getId());
        System.out.println(factory.getName());
        System.out.println(factory.getDescription());
        ITemplate[] templates = factory.getTemplates();
        int i = 0;
        while (i < templates.length) {
            System.out.println("-----------");
            System.out.println(templates[i].getId());
            System.out.println(templates[i].getName());
            System.out.println(templates[i].getDescription());
            ++i;
        }
    }

    @Override
    public ITemplateFactory[] getChildFactories() {
        return null;
    }

    @Override
    public ITemplateFactory getParentFactory() {
        return null;
    }
}

