/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.emf.template;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StyleType implements Enumerator
{
    STANDALONE(0, "standalone", "standalone"),
    EMBEDDED(1, "embedded", "embedded");

    public static final int STANDALONE_VALUE = 0;
    public static final int EMBEDDED_VALUE = 1;
    private static final StyleType[] VALUES_ARRAY;
    public static final List<StyleType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StyleType[]{STANDALONE, EMBEDDED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StyleType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StyleType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StyleType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            StyleType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static StyleType get(int value) {
        switch (value) {
            case 0: {
                return STANDALONE;
            }
            case 1: {
                return EMBEDDED;
            }
        }
        return null;
    }

    private StyleType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

