/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.stardust.modeling.templates.views.WorkbenchPageListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WorkbenchWindowListener
implements IWindowListener {
    private WorkbenchPageListener pageListener;
    private Set registeredWindows = new HashSet();

    public WorkbenchWindowListener(WorkbenchPageListener pageListener) {
        this.pageListener = pageListener;
        this.register();
    }

    public void register() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            this.registerListeners(windows[i]);
            ++i;
        }
    }

    public void unregister() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.removeWindowListener((IWindowListener)this);
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            this.removeListeners(windows[i]);
            ++i;
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.removeListeners(window);
    }

    public void windowOpened(IWorkbenchWindow window) {
        this.registerListeners(window);
    }

    private void registerListeners(IWorkbenchWindow window) {
        if (!this.registeredWindows.contains(window)) {
            this.registeredWindows.add(window);
            this.pageListener.register(window);
        }
    }

    private void removeListeners(IWorkbenchWindow window) {
        if (this.registeredWindows.contains(window)) {
            this.registeredWindows.remove(window);
            this.pageListener.unregister(window);
        }
    }
}

