/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ITypedElement;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.BridgeObject;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class TriggerValidator
implements IModelElementValidator {
    public Issue[] validate(IModelElement element) throws ValidationException {
        TriggerType trigger = (TriggerType)element;
        List result = CollectionUtils.newList();
        if (this.findDuplicateId(trigger)) {
            result.add(Issue.error((EObject)trigger, (String)Validation_Messages.MSG_TRIGGER_DuplicateId, (Object)ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (trigger.getType() == null) {
            result.add(Issue.error((EObject)trigger, (String)Validation_Messages.MSG_TRIGGER_NoTypeSet, (Object)ValidationService.PKG_CWM.getIIdentifiableElement_Name()));
        }
        for (ParameterMappingType parameterMapping : trigger.getParameterMapping()) {
            if (parameterMapping.getData() == null) {
                result.add(Issue.warning((EObject)trigger, (String)Validation_Messages.MSG_NoDataSpecifiedByParameterMapping, (Object)ValidationService.PKG_CWM.getParameterMappingType_Data()));
                continue;
            }
            String parameterId = parameterMapping.getParameter();
            if (StringUtils.isEmpty((String)parameterId)) {
                result.add(Issue.warning((EObject)trigger, (String)Validation_Messages.MSG_NoParameterSpecifiedByParameterMapping, (Object)ValidationService.PKG_CWM.getParameterMappingType_Parameter()));
                continue;
            }
            AccessPointType accessPoint = this.findAccessPoint(trigger, parameterId);
            if (accessPoint == null) {
                result.add(Issue.warning((EObject)trigger, (String)Validation_Messages.MSG_NoParameterSpecifiedByParameterMapping, (Object)ValidationService.PKG_CWM.getParameterMappingType_Parameter()));
                continue;
            }
            if (!ModelUtils.isValidId((String)accessPoint.getId())) {
                result.add(Issue.warning((EObject)accessPoint, (String)MessageFormat.format(Validation_Messages.ERR_ELEMENT_InvalidId, accessPoint.getId()), (Object)ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
            }
            try {
                BridgeObject.checkMapping((ITypedElement)parameterMapping.getData(), parameterMapping.getDataPath(), (ITypedElement)accessPoint, parameterMapping.getParameterPath());
            }
            catch (ValidationException validationException) {
                result.add(Issue.warning((EObject)trigger, (String)Validation_Messages.MSG_ParameterMappingInvalidTypeConversion, (Object)ValidationService.PKG_CWM.getParameterMappingType_ParameterPath()));
            }
        }
        return result.isEmpty() ? Issue.ISSUE_ARRAY : result.toArray(Issue.ISSUE_ARRAY);
    }

    private AccessPointType findAccessPoint(TriggerType trigger, String parameter) {
        return (AccessPointType)ModelUtils.findElementById((List)trigger.getAccessPoint(), (String)parameter);
    }

    private boolean findDuplicateId(TriggerType trigger) {
        ProcessDefinitionType process = (ProcessDefinitionType)trigger.eContainer();
        TriggerType other = (TriggerType)ModelUtils.findElementById((List)process.getTrigger(), (String)trigger.getId());
        return other != null && other != trigger;
    }
}

