/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.IModelValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidatorRegistry;

public class ValidationService {
    public static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private static ValidationService validationService;
    private ThreadLocal<IProgressMonitor> monitor = new ThreadLocal();

    public Issue[] validateModel(ModelType model) {
        List<Issue> result = null;
        if (!this.isCanceled()) {
            IModelValidator[] validators = ValidatorRegistry.getModelValidators();
            int i = 0;
            while (!this.isCanceled() && i < validators.length) {
                try {
                    Issue[] issues = validators[i].validate(model);
                    result = this.safeAddIssues(result, issues);
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        return this.safeToArray(result);
    }

    public Issue[] validateModelElements(List<?> elements) {
        List<Issue> result = null;
        if (!this.isCanceled()) {
            for (Object element : elements) {
                if (this.isCanceled()) break;
                if (!(element instanceof IModelElement)) continue;
                Issue[] issues = this.validateModelElement((IModelElement)element);
                result = this.safeAddIssues(result, issues);
            }
        }
        return this.safeToArray(result);
    }

    public Issue[] validateModelElement(IModelElement element) {
        List result = null;
        if (!this.isCanceled()) {
            IModelElementValidator[] validators = ValidatorRegistry.getModelElementValidators(element);
            int i = 0;
            while (!this.isCanceled() && i < validators.length) {
                block5: {
                    try {
                        Issue[] issues = validators[i].validate(element);
                        result = this.safeAddIssues(result, issues);
                    }
                    catch (Exception e) {
                        if (!(e.getCause() instanceof ValidationException) || !(element instanceof DataMappingType)) break block5;
                        if (result == null) {
                            result = CollectionUtils.newList();
                        }
                        ValidationException cause = (ValidationException)((Object)e.getCause());
                        EStructuralFeature feature = this.getFeature((DataMappingType)element, cause.getSource());
                        result.add(Issue.warning((EObject)element, cause.getMessage(), feature));
                    }
                }
                ++i;
            }
        }
        return this.safeToArray(result);
    }

    private Issue[] safeToArray(List<Issue> result) {
        return result == null || this.isCanceled() ? Issue.ISSUE_ARRAY : result.toArray(Issue.ISSUE_ARRAY);
    }

    private List<Issue> safeAddIssues(List<Issue> result, Issue[] issues) {
        if (issues != null && issues.length > 0) {
            if (result == null) {
                result = CollectionUtils.newList();
            }
            int j = 0;
            while (j < issues.length) {
                result.add(issues[j]);
                ++j;
            }
        }
        return result;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor.set(monitor);
    }

    private boolean isCanceled() {
        IProgressMonitor monitor = this.monitor.get();
        return monitor == null ? false : monitor.isCanceled();
    }

    private EStructuralFeature getFeature(DataMappingType dataMapping, Object source) {
        if (source != null) {
            if (source.equals(dataMapping.getData())) {
                return PKG_CWM.getDataMappingType_Data();
            }
            if (source.equals(dataMapping.getDataPath())) {
                return PKG_CWM.getDataMappingType_DataPath();
            }
            if (source instanceof AccessPointType && ((AccessPointType)source).getId().equals(dataMapping.getApplicationAccessPoint())) {
                return PKG_CWM.getDataMappingType_ApplicationAccessPoint();
            }
            if (source.equals(dataMapping.getApplicationPath())) {
                return PKG_CWM.getDataMappingType_ApplicationPath();
            }
        }
        return null;
    }

    public static ValidationService getInstance() {
        if (validationService == null) {
            validationService = new ValidationService();
        }
        return validationService;
    }
}

