/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.validation.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.validation.IModelElementValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.Validation_Messages;

public class ActivityValidator
implements IModelElementValidator {
    private static final int JOIN = 0;
    private static final int SPLIT = 1;

    @Override
    public Issue[] validate(IModelElement element) throws ValidationException {
        ArrayList<Issue> result = new ArrayList<Issue>();
        ActivityType activity = (ActivityType)element;
        if (this.findDuplicateId(activity)) {
            result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_DuplicateId, ValidationService.PKG_CWM.getIIdentifiableElement_Id()));
        }
        if (ActivityUtil.isInteractive((ActivityType)activity)) {
            if (activity.getPerformer() == null) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoPerformerSet, ValidationService.PKG_CWM.getActivityType_Performer()));
            }
        } else if (activity.getPerformer() != null) {
            result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_PerformerWronglySet, ValidationService.PKG_CWM.getActivityType_Performer()));
        }
        if (ActivityUtil.isSubprocessActivity((ActivityType)activity)) {
            if (activity.getImplementationProcess() == null) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoImplementationProcess, ValidationService.PKG_CWM.getActivityType_ImplementationProcess()));
            } else if (activity.getSubProcessMode() == null) {
                result.add(Issue.warning((EObject)activity, MessageFormat.format(Validation_Messages.ERR_ACTIVITY_SubProcessMode, activity.getName()), ValidationService.PKG_CWM.getActivityType_SubProcessMode()));
            }
        }
        if (ActivityUtil.isApplicationActivity((ActivityType)activity) && activity.getApplication() == null) {
            result.add(Issue.error((EObject)activity, MessageFormat.format(Validation_Messages.ERR_ACTIVITYNoApplication, activity.getName()), ValidationService.PKG_CWM.getActivityType_Application()));
        }
        if ((activity.getJoin() == null || activity.getJoin().getValue() == 0) && this.hasMultipleTransitions(activity, 0)) {
            result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_MultipleIncomingTransitions, ValidationService.PKG_CWM.getTransitionType_To()));
        }
        if ((activity.getSplit() == null || activity.getSplit().getValue() == 0) && this.hasMultipleTransitions(activity, 1)) {
            result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_MultipleOutgoingTransitions, ValidationService.PKG_CWM.getTransitionType_From()));
        }
        if (activity.getLoopType() != null && (activity.getLoopType().getValue() == 2 || activity.getLoopType().getValue() == 3)) {
            if (activity.getLoopCondition() == null || activity.getLoopCondition().trim().length() == 0) {
                result.add(Issue.error((EObject)activity, Validation_Messages.ERR_ACTIVITY_NoLoopCondition, ValidationService.PKG_CWM.getActivityType_LoopCondition()));
            } else if (!this.isValidLoopCondition(activity.getLoopCondition())) {
                result.add(Issue.warning((EObject)activity, Validation_Messages.ERR_ACTIVITY_InvalidLoopCondition, ValidationService.PKG_CWM.getActivityType_LoopCondition()));
            }
        }
        ValidationService vs = ValidationService.getInstance();
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)activity.getDataMapping())));
        result.addAll(Arrays.asList(vs.validateModelElements((List<?>)activity.getEventHandler())));
        return result.toArray(Issue.ISSUE_ARRAY);
    }

    private boolean isValidLoopCondition(String condition) {
        return true;
    }

    private boolean hasMultipleTransitions(ActivityType activity, int type) {
        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
        int count = 0;
        EList transitions = process.getTransition();
        int i = 0;
        while (i < transitions.size()) {
            TransitionType trans = (TransitionType)transitions.get(i);
            switch (type) {
                case 0: {
                    if (trans.getTo() != activity) break;
                    ++count;
                    break;
                }
                case 1: {
                    if (trans.getFrom() != activity) break;
                    ++count;
                }
            }
            if (count > 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean findDuplicateId(ActivityType activity) {
        for (ActivityType otherActivity : ModelUtils.findContainingProcess((EObject)activity).getActivity()) {
            if (!otherActivity.getId().equals(activity.getId()) || activity.equals(otherActivity)) continue;
            return true;
        }
        return false;
    }
}

